% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reachable.R
\name{get_adj_list}
\alias{get_adj_list}
\title{Returns an adjacency list from an edge list}
\usage{
get_adj_list(el, n_nodes)
}
\arguments{
\item{el}{An edge list as a data.frame with columns \code{head} and \code{tail}}

\item{n_nodes}{The size number of node in the network}
}
\value{
An adjacency list for the network
}
\description{
Returns an adjacency list from an edge list
}
\details{
The adjacency list is a \code{list} of length \code{n_nodes}. The entry for each node
is a integer vector containing the index of all the nodes connected to it.
This layout makes it directly subsetable in O(1) at the expanse of memory
usage.
To get all connections to the nodes 10 and 15 : \verb{unlist(adj_list[c(10, 15)]}
}
