% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanTest_supportingFunctions.R
\name{meanTest_func}
\alias{meanTest_func}
\title{An internal function of the EquiTrends Mean Equivalence Testing procedure}
\usage{
meanTest_func(
  data,
  equiv_threshold,
  vcov,
  cluster,
  alpha,
  n,
  no_periods,
  base_period,
  is_panel_balanced
)
}
\arguments{
\item{data}{The data.frame object containing the data for the test. Should be of the form what is returned by the \link[EquiTrends]{EquiTrends_dataconstr} function.}

\item{equiv_threshold}{The equivalence threshold for the test. If NULL, the minimum equivalence threshold for which the null hypothesis can be rejected is calculated.}

\item{vcov}{The variance-covariance matrix estimator. See \link[EquiTrends]{meanEquivTest} for more information.}

\item{cluster}{The cluster variable for the cluster-robust variance-covariance matrix estimator. See \link[EquiTrends]{meanEquivTest} for more information.}

\item{alpha}{The significance level for the test. Only required if no equivalence threshold is supplied.}

\item{n}{The number of cross-sectional individuals in the data.}

\item{no_periods}{The number of periods in the data.}

\item{base_period}{The base period for the test. Must be one of the unique periods in the data.}

\item{is_panel_balanced}{A logical value indicating whether the panel data is balanced.}
}
\value{
#' An object of class "meanEquivTest" containing:
\item{\code{placebo_coefficients}}{A numeric vector of the estimated placebo coefficients,}
\item{\code{abs_mean_placebo_coefs}}{the absolute value of the mean of the placebo coefficients,}
\item{\code{var_mean_placebo_coef}}{the estimated variance of the mean placebo coefficient,}
\item{\code{significance_level}}{the significance level of the test,}
\item{\code{num_individuals}}{the number of cross-sectional individuals in the data,}
\item{\code{num_periods}}{the number of periods in the data,}
\item{\code{base_period}}{the base period in the data,}
\item{\code{num_observations}}{the total number of observations in the data,}
\item{\code{equiv_threshold_specified}}{a logical value indicating whether an equivalence threshold was specified.}
\item{\code{is_panel_balanced}}{a logical value indicating whether the panel data is balanced.}

If \code{is.null(equiv_threshold)}, then additionally \code{minimum_equiv_threshold}: the minimum equivalence threshold for which the null hypothesis of non-negligible (based on the equivalence threshold) trend-differnces can be rejected. 

if \code{!(is.null(equiv_threshold))}, then additionally
\itemize{
\item \code{mean_critical_value}: the critical value at the alpha level,
\item \code{p_value}: the p-value of the test,
\item \code{reject_null_hypothesis}: A logical value indicating whether to reject the null hypothesis,
\item \code{equiv_threshold}: the equivalence threshold specified.
}
}
\description{
This is a supporting function of the \code{meanEquivTest} function. It calculates the placebo coefficients and the absolute value of the mean of the placebo coefficients. It then calculates the critical value and p-values if an equivalence threshold is supplied for the test, according to Dette & Schumann (2024). If equivalence threshold is not supplied, it calculates the minimum equivalence threshold for which the null of non-negligible pre-trend differences can be rejected.
}
\references{
Dette, H., & Schumann, M. (2024). "Testing for Equivalence of Pre-Trends in Difference-in-Differences Estimation." \emph{Journal of Business & Economic Statistics}, 1–13. DOI: \doi{10.1080/07350015.2024.2308121}
}
