% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pamWrapper.R
\name{pamCluster}
\alias{pamCluster}
\title{Partitioning Around Medoids (PAM) Clustering}
\usage{
pamCluster(data = NULL, ...)
}
\arguments{
\item{data}{A Data set}

\item{\dots}{k: The number of clusters}
}
\value{
A list of cluster labels and a R object of class "pam {cluster}"
}
\description{
This function partitions (clustering) of the data into k clusters "around medoids".
In contrast to the k-means algorithm, this clustering methods chooses actual data
points as centers
}
\examples{
library(datasets)
data(iris)

rndSamples <- sample(nrow(iris),100)
trainData <- iris[rndSamples,]
testData <- iris[-rndSamples,]

cls <- pamCluster(trainData[,1:4],3)
}
