% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layard.R
\name{layard}
\alias{layard}
\title{Test for homogeneity of variances of Layard}
\usage{
layard(trat, resp, t, r)
}
\arguments{
\item{trat}{Numeric or complex vector containing treatments.}

\item{resp}{Numeric or complex vector containing the response
variable.}

\item{t}{Number of treatments.}

\item{r}{Numeric or complex vector containing the number of
replications of each treatment.}
}
\value{
Returns the p-value of the Layard test of homogeneity
of variances and its practical interpretation for the
significance level of 5\%.
}
\description{
\code{layard} Performs the test for homogeneity of variances
of Layard for Jackknife (1973).
}
\examples{
data(ex1)
attach(ex1)
crd(trat, ig, quali = FALSE, hvar = "layard")
}
\references{
LAYARD, M. N. J. Robust large-sample tests for
homogeneity of variances. \emph{Journal of the American
Statistical Association}, v.68, n.341, p.195-198, 1973.

NOGUEIRA, D, P.; PEREIRA, G, M. Desempenho de testes para
homogeneidade de variancias em delineamentos inteiramente
casualizados. \emph{Sigmae}, Alfenas, v.2, n.1, p. 7-22.
2013.
}
\seealso{
\code{\link{bartlett}}, \code{\link{samiuddin}},
\code{\link{levene}}, \code{\link{oneillmathews}}.
}
\author{
Eric B Ferreira,
 \email{eric.ferreira@unifal-mg.edu.br}
 @author Denismar Alves Nogueira
 @author Marcos Costa de Paula
 @author Mateus Pimenta Siqueira Lima
}
