% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetDAtable.R
\name{GetDAtable}
\alias{GetDAtable}
\title{Non-additive expression analysis}
\usage{
GetDAtable(P1_RPM, P2_RPM, F1_RPM, type, homoeologs, rpm_threshold = 1)
}
\arguments{
\item{P1_RPM}{A data frame. The RPM table of genes in P1 species. For the RPM table, the first column is the gene identifier, and other columns are the RPM values of the genes in each biological replicate.}

\item{P2_RPM}{A data frame. The RPM table of genes in P2 species.}

\item{F1_RPM}{A data frame. The RPM table of genes in F1 species.}

\item{type}{A character. "sRNA" or "mRNA".}

\item{homoeologs}{A data frame. Orthologous relationships of genes in the parental species and their progeny. Only required when the 'type' is 'mRNA'.}

\item{rpm_threshold}{A numeric. Threshold for filtering out the lowly expressed genes. The default is 1 (the average RPM of all replicates).}
}
\value{
A data frame. Classification results of non-additive expression analysis based on |d/a|.
}
\description{
About the classification method based on |d/a|, the additive (a) and dominant (d) values were calculated by the expression level of each miRNA. Edwards et al. proposed that the "|d/a|" can be used as the criterion to estimate the expression patterns of miRNAs. Specific classification criteria are as follows, |d/a| <= 0.2, additivity; |d/a| > 0.2 and |d/a| <= 0.8, partial dominance; |d/a| > 0.8 and |d/a| <= 1.2, dominance; |d/a| > 1.2, overdominance.
}
\details{
The 'homoeologs' table contains the orthologs pairs. In detail, the first column is the group name (unique) of homoeologs among three species (Parents: P1; P2, Progeny: F1), the second column is the Gene ID of P1, the third column is the Gene ID of P2. And the fourth column and fifth columns are the identifier of F1 orthologs derived from P1 and P2 ancestors, respectively (e.g. "Homoeolog1	BraA01t00004Z	BolC01g000040.2J BnA01g0000030.1 BnC01g0424620.1").
}
\examples{
DAresult <- GetDAtable(P1_RPM = P1_miRNA_rpm,
                       P2_RPM = P2_miRNA_rpm,
                       F1_RPM = F1_miRNA_rpm,
                       type = "sRNA", rpm_threshold = 1)
}
\references{
Edwards MD, Stuber CW, Wendel JF. Molecular-marker-facilitated investigations of quantitative-trait loci in maize. I. Numbers, genomic distribution and types of gene action. Genetics. 1987 May;116(1):113-25.
}
