% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmleFHP.R
\name{mmleFHP}
\alias{mmleFHP}
\title{Marginal MLEs for the Fay-Herriot model with known covariance}
\usage{
mmleFHP(y, X, Sigma)
}
\arguments{
\item{y}{direct data following normal model \eqn{y\sim N(\theta,\Sigma)}}

\item{X}{linking model predictors \eqn{ \theta\sim N(X\beta,\tau^2 I)}}

\item{Sigma}{covariance matrix in sampling model}
}
\value{
a list of parameter estimates including 
\enumerate{
\item beta, the estimated regression coefficients
\item t2, the estimate of \eqn{\tau^2} 
}
}
\description{
Marginal MLEs for the Fay-Herriot random effects model where 
the covariance matrix for the sampling model is known
}
\examples{
n<-30 ; p<-3 
X<-matrix(rnorm(n*p),n,p)  
beta<-rnorm(p) 
theta<-X\%*\%beta + rnorm(n)  
Sigma<-diag(n) 
y<-theta+rnorm(n) 
mmleFHP(y,X,Sigma) 

}
\author{
Peter Hoff
}
