% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommend.R
\name{recommend}
\alias{recommend}
\title{Obtain recommendations based on Mai et al. (2021)}
\usage{
recommend(
  fits,
  purpose = "novel",
  focus = "cfa",
  override = FALSE,
  index = NULL,
  digits = 3
)
}
\arguments{
\item{fits}{A list of simulated fit indices obtained from gen_fit. Based on the structure of fits, the number of models is derived.}

\item{purpose}{The research purpose of the model investigated. Is the underlying model novel (default) or established (= established). This parameter is relevant to find the proper recommended fit indices.}

\item{focus}{The focus of estimation for the model. Is the focus on CFA (default) or analyzing the structural model of a theoretical model (= structural)? This parameter is relevant to find the proper recommended fit indices.}

\item{override}{Should the recommendations by Mai et al. (2021) overridden (default: FALSE)?  This may be useful to explore models outside of the scope of the paper. In this case, the recommended fit indices are not determined by the function, and hence need to be provided.
In this case, the function requires the argument index.}

\item{index}{An optional vector of fit indices or measures provided by function fitmeasures in package lavaan. This argument is required when override is TRUE. It is ignored otherwise.}

\item{digits}{An optional integer to round fit values and cutoffs (min: 1, max: 5).}
}
\value{
A list of information regarding the recommended fit indices based on Mai et al. (2021) or when overridden, based on the provided indices.
}
\description{
This function recommends pre-defined selected fit indices in case the user does not know which fit index should be used for model evaluation. Results may differ based on three settings, the sample size of the data, the research purpose of the investigated model and the focus of the model. For obvious reasons, this function only works for single models and does not accept any other model type.
}
\examples{
#Note: Demonstration only! Please use higher numbers of replications for your applications (>= 500).
mod <- "
F1 =~ Q5 + Q7 + Q8
F2 =~ Q2 + Q4
F3 =~ Q10 + Q11 + Q12 + Q13 + Q18 + Q19 + Q20 + Q21 + Q22
F4 =~ Q1 + Q17
F5 =~ Q6 + Q14 + Q15 + Q16
"
fits.single <- gen_fit(mod1 = mod, x = bb1992, rep = 10, standardized = FALSE)
recommend(fits.single)
recommend(fits.single, purpose = "established")
recommend(fits.single,
         override = TRUE,
         index = c("CFI", "SRMR"))
}
\references{
Mai, R., Niemand, T., & Kraus, S. (2021). A Tailor-Fit Model Evaluation Strategy for Better Decisions about Structural Equation Models, Technological Forecasting & Social Change, 173(December) 121142. https://doi.org/10.1016/j.techfore.2021.121142
}
