% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_power.R
\name{average.power.signrank}
\alias{average.power.signrank}
\title{Compute average power of many signed-rank tests}
\usage{
average.power.signrank(n, alpha, p1, p2)
}
\arguments{
\item{n}{sample size (scalar)}

\item{alpha}{p-value threshold (scalar)}

\item{p1}{Pr(X>0), as in Noether (JASA 1987)}

\item{p2}{Pr(X+X'>0), as in Noether (JASA 1987)}
}
\value{
Average power estimate for multiple testing procedure
}
\description{
Compute average power of many signed-rank tests
}
\examples{
p1 = rep(c(0.8,0.5),c(100,900));
p2 = rep(c(0.8,0.5),c(100,900));
average.power.signrank(n = 50, alpha = 0.05, p1 = p1, p2 = p2)
}
\seealso{
\code{\link{power.signrank}} for more details about power calculation of signed-rank test. The power calculation is based on asymptotic normal approximation.
}
