% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{n.fdr.tcorr}
\alias{n.fdr.tcorr}
\title{Sample size calculation for t-tests for non-zero correlation}
\usage{
n.fdr.tcorr(fdr, pwr, rho, pi0.hat = "BH")
}
\arguments{
\item{fdr}{desired FDR (scalar numeric)}

\item{pwr}{desired average power (scalar numeric)}

\item{rho}{population correlation coefficient (vector)}

\item{pi0.hat}{method to estimate proportion \code{pi0} of tests with true null, including: "HH" (p-value histogram height), "HM" (p-value histogram mean), "BH" (Benjamini & Hochberg 1995), "Jung" (Jung 2005)}
}
\value{
A list with the following components:
\item{n}{sample size estimate}
\item{computed.avepow}{average power}
\item{desired.avepow}{desired average power}
\item{desired.fdr}{desired FDR}
\item{input.pi0}{proportion of tests with a true null hypothesis}
\item{alpha}{fixed p-value threshold for multiple testing procedure}
\item{n.its}{number of iteration}
\item{max.its}{maximum number of iteration, default is 50}
\item{n0}{lower limit for initial sample size range}
\item{n1}{upper limit for initial sample size range}
}
\description{
Find the sample size needed to have a desired false discovery rate and average power for a large number of t-tests for non-zero correlation.
}
\examples{
rho = rep(c(0.3,0),c(100,900));
n.fdr.tcorr(fdr = 0.1, pwr = 0.8, rho = rho, pi0.hat="BH")
}
