% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_assessment.R
\name{ess_model}
\alias{ess_model}
\title{Model-based Effective Sample Size (ESS)}
\usage{
ess_model(X_cov, assign_matrix, Y_mat, contrast = c(1, -1))
}
\arguments{
\item{X_cov}{A matrix of covariates or transformations thereof that will be used
as explanatory variables in the linear outcome models within each treatment group.}

\item{assign_matrix}{A matrix containing a collection of treatment assignment vectors, each column
containing a particular assignment vector.}

\item{Y_mat}{A matrix of potential outcomes, where rows represent units and columns represent treatment
levels (ordered).}

\item{contrast}{A vector of the coefficients of the treatment contrast of interest. For example, for estimating the
average treatment effect of treatment 1 versus treatment 2, \code{contrast = c(1,-1)}.}
}
\value{
A vector of effective sample sizes for the given collection of assignments.
}
\description{
Computes the model-based effective sample size (ESS) of a collection of assignments 
under a given set of potential outcomes.
}
\examples{
# Consider the Lalonde dataset.
# Get the full sample size.
N = nrow(Lalonde)
# Get the treatment group sizes.
n1 = floor(N/2)
n2 = N-n1
# Generate an SOM.
som_obs = som(n_treat = 2, treat_sizes = c(n1,n2),include_discard = FALSE,
method = 'SCOMARS', marginal_treat = rep((n2/N),N), control = FALSE)
# Generate a treatment assignment given som_obs.
f = fsm(data_frame = Lalonde, SOM = som_obs, s_function = 'Dopt', eps = 0.0001, 
ties = 'random', intercept = TRUE, standardize = TRUE, units_print = FALSE)
# Get assignment vector under the FSM.
Z_fsm_obs = f$data_frame_allocated$Treat
# Draw a random CRD.
Z_crd_obs = crd(data_frame = Lalonde, n_treat = 2, treat_sizes = c(n1, n2), 
control = FALSE)$Treat
Z_big = cbind(Z_crd_obs, Z_fsm_obs)
# Generate the potential outcomes.
Y_1 = 100 - Lalonde$Age + 6 * Lalonde$Education - 20 * Lalonde$Black + 
20 * Lalonde$Hispanic + 0.003 * Lalonde$Re75 + rnorm(N,0,4)
Y_1 = round(Y_1,2)
# Set unit level causal effect = tau = 0.
tau = 0
Y_2 = Y_1 + tau
# Get the matrix of potential outcomes.
Y_appended = cbind(Y_1, Y_2)
# Get the matrix of covariates.
X_cov = Lalonde[,-1]
ess = ess_model(X_cov = X_cov, assign_matrix = Z_big, Y_mat = Y_appended, contrast = c(1,-1))
}
\references{
Chattopadhyay, A., Morris, C. N., and Zubizarreta, J. R. (2020), ``Randomized and Balanced Allocation 
of Units into Treatment Groups Using the Finite Selection Model for \code{R}".
}
\author{
Ambarish Chattopadhyay, Carl N. Morris and Jose R. Zubizarreta.
}
