% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsm_batch_without_strata.R
\name{fsm_batch}
\alias{fsm_batch}
\title{Batched FSM for sequential experiments}
\usage{
fsm_batch(
  data_frame,
  data_frame_past,
  t_ind,
  SOM,
  s_function = "Dopt",
  Q_initial = NULL,
  eps = 0.001,
  ties = "random",
  intercept = TRUE,
  index_col_past = TRUE,
  standardize = TRUE,
  units_print = TRUE,
  index_col = TRUE,
  Pol_mat = NULL,
  w_pol = NULL
)
}
\arguments{
\item{data_frame}{Data frame containing a column of unit indices (optional) and covariates (or transformations thereof).}

\item{data_frame_past}{A data frame of units already allocated to treatment groups. 
Data frame contains a column of unit indices (optional), columns of covariates (or transformations thereof), 
and a column for treatment indicator.}

\item{t_ind}{column name containing the treatment indicator in \code{data_frame_past}.}

\item{SOM}{Selection Order Matrix.}

\item{s_function}{Specifies a selection function, a string among \code{'constant'}, \code{'Dopt'}, 
\code{'Aopt'}, \code{'max pc'}, \code{'min pc'}, \code{'Dopt pc'}, \code{'max average'}, \code{'min average'},
\code{'Dopt average'}. \code{'constant'} selection function puts a constant value on every unselected unit. 
\code{'Dopt'} use the D-optimality criteria based on the full set of covariates to select units. 
\code{'Aopt'} uses the A-optimality criteria. \code{'max pc'} (respectively, \code{'min pc'}) selects that 
unit that has the maximum (respectively, minimum) value of the first principal component. 
\code{'Dopt pc'} uses the D-optimality criteria on the first principal component, \code{'max average'} 
(respectively, \code{'min average'}) selects that unit that has the maximum (respectively, minimum) 
value of the simple average of the covariates. \code{'Dopt average'} uses the D-optimality criteria on the 
simple average of the covariates.}

\item{Q_initial}{A (optional) non-singular matrix (called 'initial matrix') that is added the \eqn{(X^T X)} 
matrix of the choosing treatment group at any stage, when the \eqn{(X^T X)} matrix of that treatment group
at that stage is non-invertible. If \code{FALSE}, the \eqn{(X^T X)} matrix for the full set of observations is used
as the non-singular matrix. Applicable if \code{s_function = 'Dopt'} or \code{'Aopt'}.}

\item{eps}{Proportionality constant for \code{Q_initial}, the default value is 0.001.}

\item{ties}{Specifies how to deal with ties in the values of the selection function. If \code{ties = 'random'},
a unit is selected randomly from the set of candidate units. If \code{ties = 'smallest'}, the unit 
that appears earlier in the data frame, i.e. the unit with the smallest index gets selected.}

\item{intercept}{if \code{TRUE}, the design matrix of each treatment group includes a column of intercepts.}

\item{index_col_past}{\code{TRUE} if column of unit indices is present in \code{data_frame_past}.}

\item{standardize}{if \code{TRUE}, the columns of the \eqn{X} matrix other than the column for the intercept (if any), 
are standardized.}

\item{units_print}{if \code{TRUE}, the function automatically prints the candidate units at each step of selection.}

\item{index_col}{if \code{TRUE}, data_frame contains a column of unit indices.}

\item{Pol_mat}{Policy matrix. Applicable only when \code{s_function = 'Aopt'}.}

\item{w_pol}{A vector of policy weights. Applicable only when \code{s_function = 'Aopt'}.}
}
\value{
A list containing the following items.

\code{data_frame_allocated}:  The original data frame augmented with the column of the treatment indicator.

\code{som_appended}:  The SOM with augmented columns for the indices and covariate values for units selected.

\code{som_split}:  som_appended, split by the levels of the treatment.

\code{data_frame_allocated_augmented}: data frame combining \code{data_frame_allocated} and \code{data_frame_past}.
}
\description{
Extension of the FSM to cases where units arrive sequentially in batches.
}
\examples{
# Consider N=18, number of treatments = 2, n1 = n2 = 9, batch sizes = 6,6,6.
# Get data frame for the first batch.
df_sample_1 = data.frame(index = 1:6, age = c(20,30,40,40,50,60))
# Obtain SOM for all the 12 units.
som_gen = som(data_frame = NULL, n_treat = 2, treat_sizes = c(9,9), 
include_discard = FALSE, method = 'SCOMARS', marginal_treat = rep((9/18),18), control = FALSE)
# Assign the first batch.
f1 = fsm(data_frame = df_sample_1, SOM = som_gen[1:6,], s_function = 'Dopt', 
eps = 0.0001, ties = 'random', intercept = TRUE, standardize = TRUE, units_print = TRUE)
f1_app = f1$data_frame_allocated
# Get data frame for the second batch.
df_sample_2 = data.frame(index = 7:12, age = c(20,30,40,40,50,60))
# Assign the second batch.
f2 = fsm_batch(data_frame = df_sample_2, SOM = som_gen[7:12,], s_function = 'Dopt', 
eps = 0.0001, ties = 'random', intercept = TRUE, standardize = TRUE, units_print = TRUE,
data_frame_past = f1_app, t_ind = 'Treat', index_col_past = TRUE)
f2_app = f2$data_frame_allocated_augmented
# Get data frame for the third batch.
df_sample_3 = data.frame(index = 13:18, age = c(20,30,40,40,50,60))
# Assign the third batch.
f3 = fsm_batch(data_frame = df_sample_3, SOM = som_gen[13:18,], s_function = 'Dopt', 
eps = 0.0001, ties = 'random', intercept = TRUE, standardize = TRUE, units_print = TRUE,
data_frame_past = f2_app, t_ind = 'Treat', index_col_past = TRUE)
f3_app = f3$data_frame_allocated_augmented
}
\references{
Chattopadhyay, A., Morris, C. N., and Zubizarreta, J. R. (2020), ``Randomized and Balanced Allocation of Units into Treatment Groups Using the Finite Selection Model for \code{R}'.
}
\author{
Ambarish Chattopadhyay, Carl N. Morris and Jose R. Zubizarreta
}
