% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.fgarch.R
\name{dgp.fgarch}
\alias{dgp.fgarch}
\title{Functional ARCH/GARCH Process Generator}
\usage{
dgp.fgarch(J, N, type, alpha_par = NULL, beta_par = NULL)
}
\arguments{
\item{J}{The number of grid point in each curve observation.}

\item{N}{The sample size.}

\item{type}{A string to switch data generating process between "arch" - functional ARCH and "garch" - functional GARCH.}

\item{alpha_par}{The ARCH kernel coefficient function in the conditional volatility equation. If it is missing, "\eqn{12 t (1-t) s (1-s)}" is used to generate FGARCH, and "\eqn{16 t (1-t) s (1-s)}" is used to generate FARCH, for \eqn{t\in[0,1]} and \eqn{s\in[0,1]}.}

\item{beta_par}{The GARCH kernel coefficient function in the conditional volatility equation. If it is missing, "\eqn{12 t (1-t) s (1-s)}" is used to generate FGARCH, for \eqn{t\in[0,1]} and \eqn{s\in[0,1]}.}
}
\value{
List of generated processes:

garch_mat: FARCH/GARCH sequences, where the finite realization of curves are stored in columns;

sigma_mat: Conditional volatility sequences,  where the finite realization of curves are stored in columns.
}
\description{
It generates functional curve data following the functional ARCH(1) or GARCH(1,1) process.
}
\details{
If \eqn{X_i(t)} follows an FARCH(1) process,\cr
\eqn{X_i(t)=\sigma_i(t)\varepsilon_i(t)}, \eqn{t \in [0,1]},\cr
\eqn{\sigma_i^2(t)=\omega(t)+\int \alpha(t,s) X^2_{i-1}(s)ds}.\cr

If \eqn{X_i(t)} follows an FGARCH(1,1) process,\cr
\eqn{X_i(t)=\sigma_i(t)\varepsilon_i(t)}, \eqn{t \in [0,1]},\cr
\eqn{\sigma_i^2(t)=\omega(t)+\int \alpha(t,s) X^2_{i-1}(s)ds+\int \beta(t,s) \sigma^2_{i-1}(s)ds},\cr
where the innovation \eqn{\varepsilon_i(t)} follows an Ornstein–Uhlenbeck process \code{\link{dgp.ou}}, and the constant coefficient \eqn{\omega(t)=0.1t(1-t)}.
}
\examples{
\donttest{
# Generate discrete evaluations of 100 fGARCH curves that
# each curve is realized on 50 grid points.
yd = dgp.fgarch(J = 50, N = 100, type = "garch")
yd_garch = yd$garch_mat
}
}
\references{
[1] Hormann, S., Horvath, L., Reeder, R. (2013). A functional version of the ARCH model. Econometric Theory. 29(2), 267-288. <doi:10.1017/S0266466612000345>.\cr
[2] Aue, A., Horvath, L., F. Pellatt, D. (2017). Functional generalized autoregressive conditional heteroskedasticity. Journal of Time Series Analysis. 38(1), 3-21. <doi:10.1111/jtsa.12192>.\cr
}
\seealso{
\code{\link{dgp.ou}}
}
