% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.ou.R
\name{dgp.ou}
\alias{dgp.ou}
\title{Ornstein–Uhlenbeck Process Generator}
\usage{
dgp.ou(J, N)
}
\arguments{
\item{J}{The number of grid points in each curve observation.}

\item{N}{The sample size.}
}
\value{
A (grid points) x (number of observations) matrix for iid sequences, where the finite realization of curves are stored in columns.
}
\description{
It generates iid functional curve data following the Ornstein–Uhlenbeck process.
}
\details{
The Ornstein–Uhlenbeck process is given by:
\eqn{x_i(t)=e^{-t/2}W_i(e^t)}, \eqn{t \in [0,1]},\cr
where \eqn{W_i(t)} is a standard Brownian Motion.
}
\examples{

\donttest{
# Generate discrete evaluations of 100 iid curves
# that each curve is realized on 50 grid points.
yd_ou = dgp.ou(J = 50, N = 100)
}

}
