% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fCH_test.R
\name{fCH_test}
\alias{fCH_test}
\title{Test for Conditional Heteroscedasticity of Functional Time Series}
\usage{
fCH_test(f_data, H = 10, stat_Method = "functional", pplot = FALSE)
}
\arguments{
\item{f_data}{A \eqn{J \times N} matrix of functional time series data, where \eqn{J} is the number of discrete points in a grid and \eqn{N} is the sample size.}

\item{H}{A positive integer specifying the maximum lag for which test statistic is computed.}

\item{stat_Method}{A string specifying the test method to be used in the "ch" test. Options include:
\describe{
  \item{"norm"}{Uses \eqn{V_{N,H}}.}
  \item{"functional"}{Uses \eqn{M_{N,H}}.}
}}

\item{pplot}{A Boolean value. If TRUE, the function will produce a plot of p-values of the test
as a function of maximum lag \eqn{H}, ranging from \eqn{H=1} to \eqn{H=20}, which may increase the computation time.}
}
\value{
A list that includes the test statistic and the p-value will be returned.
}
\description{
It tests the null hypothesis that the objective functional curve data is not conditionally heteroscedastic. If a small p-value rejects the null hypothesis,  the curves exhibit conditional heteroscedasticity.
}
\details{
Given the objective curve data \eqn{X_i(t)}, for \eqn{1\leq i \leq N}, \eqn{t\in[0,1]}, the test aims at distinguishing the hypotheses:\cr \cr
\eqn{H_0}: the sequence \eqn{X_i(t)} is IID; \cr
\eqn{H_1}: the sequence \eqn{X_i(t)} is conditionally heteroscedastic. \cr \cr
Two portmanteau type statistics are applied: \cr \cr
1. the norm-based statistic: \eqn{V_{N,H}=N\sum_{h=1}^H\hat{\gamma}^2_{X^2}(h)}, where \eqn{\hat{\gamma}^2_{X^2}(h)} is the sample autocorrelation of the time series \eqn{||X_1||^2,\dots,||X_N||^2}, and \eqn{H} is a pre-set maximum lag length.\cr \cr
2. the fully functional statistic \eqn{M_{N,H}=N\sum_{h=1}^H||\hat{\gamma}_{X^2,N,h}||^2}, where the autocovariance kernel \eqn{\hat{\gamma}_{X^2,N,h}(t,s)=N^{-1}\sum_{i=1}^{N-h}[X_i^2(t)-\bar{X}^2(t)][X^2_{i+h}(s)-\bar{X}(s)]}, for \eqn{||\cdot ||} is the \eqn{L^2} norm, and \eqn{\bar{X}^2(t)=N^{-1}\sum_{i=1}^N X^2_i(t)}.
}
\examples{

\donttest{
# generate discrete evaluations of the iid curves under the null hypothesis.
yd_ou = dgp.ou(50, 100)

# test the conditional heteroscedasticity.
fCH_test(yd_ou, H=5, stat_Method="functional")
}
}
\references{
Rice, G., Wirjanto, T., Zhao, Y. (2020). Tests for conditional heteroscedasticity of functional data. Journal of Time Series Analysis. 41(6), 733-758. <doi:10.1111/jtsa.12532>.\cr
}
