% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approximatepropagateC++.R
\name{approx.propagate}
\alias{approx.propagate}
\title{Approximate the propagation of a Fleming-Viot latent signal}
\usage{
approx.propagate(fvddp, delta.t, N)
}
\arguments{
\item{fvddp}{An instance of class  generated via \code{\link[=initialize]{initialize()}}.
In order to perform the propagation, the FVDDP has to be fed some data using
\code{\link[=update]{update()}}, at least once.}

\item{delta.t}{The time of the propagation.}

\item{N}{The amount of samples to be drawn in order to perform the approximation.}
}
\value{
A object of class \code{fvddp}. Since this function is a Monte-Carlo based
approximation of \code{\link[=propagate]{propagate()}}, the outputs are similar.
}
\description{
Approximate the propagation of a Fleming-Viot latent signal
}
\examples{
#a first example
FVDDP = initialize(theta = 1, sampling.f = function(x) rpois(x, 3),
                   density.f = function(x) dpois(x, 3), atomic = TRUE)
FVDDP = update(FVDDP, c(4,5))
approx.propagate(FVDDP, 0.2, 10000)

#another example; it does not matter wether P0 is atomic or not
FVDDP=initialize(theta = 3, function(x) rnorm(x, -1, 3),
                 function(x) dnorm(x, -1, 3), atomic = FALSE)
FVDDP = update(FVDDP, c(-1.145, 0.553, 0.553, 0.553))
approx.propagate(FVDDP, 0.6, 10000)

}
\references{
{
\insertRef{AscolaniLijoiRuggiero2021}{FVDDPpkg}
}
}
\seealso{
\code{\link[=approx.propagate]{approx.propagate()}} for a (slower) exact computation.
}
