% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.fvddp}
\alias{summary.fvddp}
\title{Show the data contained within the Fleming-Viot Dependent Dirichlet Process}
\usage{
\method{summary}{fvddp}(object, ..., rows = FALSE, K = TRUE)
}
\arguments{
\item{object}{An element of class \code{fvddp}, created via \code{\link[=initialize]{initialize()}}.}

\item{...}{Optional arguments for \code{summary} methods.}

\item{rows}{Specify whether the rows must be printed. Useful in case \code{M} is large.}

\item{K}{Specify whether the values of \code{K}, the amount of clusters for each row,
must be printed.}
}
\value{
The function prints a \code{\link[base:data.frame]{base::data.frame()}} object (that is, of class
\code{"data.frame"}) where every row is a vector of multiplicities (according to
the observations as in the names of the columns), with its associated weight.
}
\description{
Show the data contained within the Fleming-Viot Dependent Dirichlet Process
}
\examples{
#iniialize a simple process and show its summary
FVDDP = initialize(2, function(x) rgeom(x, .25),
                   function(x) dgeom(x, .25), TRUE)
FVDDP = update(FVDDP, rpois(4, 2))
FVDDP = propagate(FVDDP, 0.5)
summary(FVDDP)
}
