% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_bundle.R
\name{llm_bundle}
\alias{llm_bundle}
\title{Create a fake-data bundle for LLM workflows}
\usage{
llm_bundle(
  data,
  n = 30,
  level = c("medium", "low", "high"),
  formats = c("csv", "rds"),
  path = tempdir(),
  filename = "fake_bundle",
  seed = NULL,
  write_prompt = TRUE,
  zip = FALSE,
  prompt_filename = "README_FOR_LLM.txt",
  zip_filename = NULL,
  sensitive = NULL,
  sensitive_detect = TRUE,
  sensitive_strategy = c("fake", "drop"),
  normalize = FALSE
)
}
\arguments{
\item{data}{A data.frame (or coercible) to mirror.}

\item{n}{Number of rows in the fake dataset (default 30).}

\item{level}{Privacy level: "low", "medium", or "high". Controls stricter defaults.}

\item{formats}{Which data files to write: any of "csv","rds","parquet".}

\item{path}{Folder to write outputs. Default: \code{tempdir()}.}

\item{filename}{Base file name (no extension). Example: "demo_bundle".
This becomes files like "demo_bundle.csv", "demo_bundle.rds", etc.}

\item{seed}{Optional RNG seed for reproducibility.}

\item{write_prompt}{Write a README_FOR_LLM.txt next to the data? Default TRUE.}

\item{zip}{Create a single zip archive containing data + schema + README? Default FALSE.}

\item{prompt_filename}{Name for the README file. Default "README_FOR_LLM.txt".}

\item{zip_filename}{Optional custom name for the ZIP file (no path).
If \code{NULL} (default), it is derived as \code{paste0(filename, ".zip")},
e.g. \code{"demo_bundle.zip"}.}

\item{sensitive}{Character vector of column names to treat as sensitive (optional).}

\item{sensitive_detect}{Logical, auto-detect common sensitive columns (id/email/phone). Default TRUE.}

\item{sensitive_strategy}{"fake" (replace with realistic fakes) or "drop". Default "fake".}

\item{normalize}{Logical; if TRUE, attempt light auto-normalization before faking.}
}
\value{
List with paths: $data_paths (named), $schema_path, $readme_path (optional),
$zip_path (optional), and $fake (data.frame).
}
\description{
Generates fake data, writes files (CSV/RDS/Parquet), writes a scrubbed JSON schema,
and optionally writes a README prompt and a single ZIP file containing everything.
}
\details{
\strong{Tips}
Avoid using angle brackets in examples; prefer plain tokens like \code{NAME}
or \code{FILE_NAME}. If you truly want bracket glyphs, use Unicode ⟨name⟩ ⟩name⟨.
}
