% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.approx_kernel}
\alias{print.approx_kernel}
\title{Print method for approximated kernel matrices}
\usage{
\method{print}{approx_kernel}(x, ...)
}
\arguments{
\item{x}{An S3 object created by \code{\link{approx_kernel}}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
An approximated kernel matrix and its associated options.
}
\description{
Displays the approximated kernel matrix and key options used to construct it.
}
\details{
The function prints the stored approximated kernel matrix (top-left 6x6)
and summarizes options such as the approximation method (\code{opt}), approximaion degree (\code{m}),
numerical tolerance (\code{eps}), and number of threads used (\code{n_threads}).
}
\examples{
# Data setting
set.seed(1)
d = 1
n = 1000
m = 50
rho = 1
X = matrix(runif(n*d, 0, 1), nrow = n, ncol = d)
y = as.vector(sin(2*pi*rowMeans(X)^3) + rnorm(n, 0, 0.1))
K = make_kernel(X, kernel = "gaussian", rho = rho)

# Example: nystrom
K_nystrom = approx_kernel(K = K, opt = "nystrom", m = m, d = d, rho = rho, n_threads = 1)
class(K_nystrom)

print(K_nystrom)
}
\seealso{
\code{\link{approx_kernel}, \link{print.krr}}, \code{\link{print.kernel_matrix}}
}
