% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling.R
\name{setNames}
\alias{setNames}
\title{Set Names of an Object}
\usage{
setNames(object, newNames)
}
\arguments{
\item{object}{An object.}

\item{newNames}{A character vector specifying the new names.}
}
\value{
The object with updated names.
}
\description{
Improvement to \code{\link[stats:setNames]{stats::setNames()}} sets new names for an object,
ensuring that the length of the new names matches the length of the object.
Additionally, if the length of newNames is one, it is repeated to match
the length of the object.
}
\examples{
# Set new names for a vector
x <- c(1, 2, 3)
x <- setNames(x, c("A", "B", "C"))

# some syntactic sugar can be achieved with a special mutator
`\%setNames\%` <- createMutator(setNames)
x \%setNames\% c("D", "E", "F")

}
\keyword{wrangling}
