% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{warningp}
\alias{warningp}
\title{Custom Warning Function Without Call}
\usage{
warningp(...)
}
\arguments{
\item{...}{Arguments passed on to \code{warning}.}
}
\value{
No return value, this function issues a warning.
}
\description{
This function provides a wrapper around the base \code{\link[base]{warning}}
function, adding flexibility to warnings by setting \code{call.} to FALSE
automatically. This modification means that the function call is not included
in the warning message, streamlining the output for users.
}
\examples{
\donttest{
try(warningp(
    "This is a custom warning message without the call."
), silent = TRUE)
}
}
\seealso{
\code{\link[base]{warning}}
}
\keyword{validation}
