% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MacroFactor.Cov.R
\name{MacroFactor.Cov}
\alias{MacroFactor.Cov}
\title{Covariance Matrix Estimation by Macroeconomic Factor Model}
\usage{
MacroFactor.Cov(assets, factor)
}
\arguments{
\item{assets}{a N*p matrix of asset returns, N indicates sample size
and p indicates the dimension of asset returns}

\item{factor}{a numerical vector of length N, or a N*q matrix of
macroeconomic factor(s), q indicates the dimension of factors}
}
\value{
an estimated p*p covariance matrix
}
\description{
Estimate covariance matrix by fitting a macroeconomic factor model
using time series regression
}
\examples{
data(m.excess.c10sp9003)
assets <- m.excess.c10sp9003[,1:10]
factor <- m.excess.c10sp9003[,11]
MacroFactor.Cov(assets, factor)
}

