% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Figures.R
\name{ChangePerIterate}
\alias{ChangePerIterate}
\title{ChangePerIterate
A function for plotting the change in each vector per iterate.}
\usage{
ChangePerIterate(
  Inputs,
  Outputs,
  ConvergenceVector = c(),
  ConvergenceSigFig = 5,
  ShowInputs = TRUE,
  ShowOutputs = TRUE,
  ShowPrevious = TRUE,
  xaxis = c(),
  secondhold = 0,
  FromIterate = 1,
  ToIterate = c()
)
}
\arguments{
\item{Inputs}{The Inputs matrix returned by FixedPoint.}

\item{Outputs}{The Outputs matrix returned by FixedPoint.}

\item{ConvergenceVector}{The Convergence vector returned by fixedpoint.}

\item{ConvergenceSigFig}{The number of significant figures convergence values should be shown with in the plot header.}

\item{ShowInputs}{A boolean describing whether to show the inputs in the figure.}

\item{ShowOutputs}{A boolean describing whether to show the outputs in the figure.}

\item{ShowPrevious}{A boolean describing whether to show the previous inputs/outputs in the figure.}

\item{xaxis}{A vector for meaningful values corresponding to the input/output values. By default the indexes of each input/output vector
are used.}

\item{secondhold}{If this is -1 or less then all plotting happens immediately. This means that very quickly only the last iterate will be seen
so it makes sense to do it only if FromIterate and ToIterate indicate only one iterate. If this is 0 then a user can click through each figure.
If this is positive then it describes how many seconds to pause between frames. By default this is 0 so a user must click through each frame.}

\item{FromIterate}{This describes what iterate to show first.}

\item{ToIterate}{This describes what iterate to show last.}
}
\value{
This function returns nothing. It just shows a plot in the console.
}
\description{
ChangePerIterate
A function for plotting the change in each vector per iterate.
}
\examples{
Inputs = seq(1,10)
Function = function(x){ cos(x) }
A = FixedPoint(Function, Inputs, Method = "Anderson")
ChangePerIterate(A$Inputs, A$Outputs, A$Convergence)
#Any now to have it play one frame every half a second starting from the nineth iterate
ChangePerIterate(A$Inputs, A$Outputs, A$Convergence, secondhold = 0.5, FromIterate = 9)
}
