% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDinterfaces.R
\name{summary.FDfitted}
\alias{summary.FDfitted}
\title{Summary Method for FDfitted Objects}
\usage{
\method{summary}{FDfitted}(object, ...)
}
\arguments{
\item{object}{an object of class FDfitted, usually the result of \code{\link{FD.estimation}}.}

\item{...}{additional arguments}
}
\value{
A list composed by:
\describe{
  \item{\code{par}}{Estimated parameter vector}
  \item{\code{sd}}{Vector of the estimated standard deviations}
  \item{\code{goodness}}{Vector containing LogLikelihood, AIC and BIC}
}
}
\description{
This method summarizes the results of \code{\link{FD.estimation}}, adding also information from the functions \code{\link{FD.stddev}} and \code{\link{FD.aicbic}}.
}
\examples{
data <- FD.generate(n=20,a=c(12,7,15),p=c(0.3,0.4,0.3),t=8)
data
results <- FD.estimation(data, normalize=TRUE,iter.initial.SEM = 5,iter.final.EM = 10)
results
summary(results)


}
\references{
{
 Ongaro, A. and Migliorati, S. (2013) A generalization of the Dirichlet distribution. Journal of Multivariate Analysis, \bold{114}, 412--426.\cr
\cr
 Migliorati, S., Ongaro, A. and Monti, G. S. (2016) A structured Dirichlet mixture model for compositional data: inferential and applicative issues. Statistics and Computing, doi:10.1007/s11222-016-9665-y.
}
}
\seealso{
\code{\link{FD.estimation}}, \code{\link{FD.stddev}}, \code{\link{FD.aicbic}}
}
