#' Annual maximum discharges of the Guadalupe River near Victoria, Texas, 1935-1978.
#'
#' A dataset containing annual maximum discharges (in cfs) of the Guadalupe River near Victoria, Texas,
#'    during 1935-1978, in cfs extracted from TABLE 12.1.1 of "Applied Hydrology" (Chow et al., 1987).
#'
#' @name AH_Tab12_1_1
#' @docType data
#'
#' @format A data frame with 44 rows and 1 variable:
#' \describe{
#'   \item{Q_cfs}{annual maximum discharges in cfs}
#'   ...
#' }
#' @source Chow, V. T., Maidment, D. R., & Mays, L. W. (1988). \emph{Applied Hydrology}.
#'    McGraw-Hill, New York, U. S.
NULL
#'
#' Annual maximum 10-minute rainfall at Chicago, Illinois, 1913-1947.
#'
#' A dataset containing annual maximum 10-minute rainfall (in inches) at Chicago, Illinois,
#'    during 1913-1947 extracted from TABLE 12.2.1 of "Applied Hydrology" (Chow et al., 1987).
#'
#' @name AH_Tab12_2_1
#' @docType data
#'
#' @format A data frame with 35 rows and 1 variable:
#' \describe{
#'   \item{PMax10min_in}{annual maximum 10-minute rainfall in inches}
#'   ...
#' }
#' @source Chow, V. T., Maidment, D. R., & Mays, L. W. (1988). Applied Hydrology.
#'    McGraw-Hill, New York, U. S.
NULL
#'
#' Observed annual peak data for the Etowah River and Suwanee Creek from 1985-2004
#'
#' A dataset containing the summary of concurrent observed annual peak data for the Etowah River and
#'    Suwanee Creek from 1985-2004 extracted from Table 8.1 in "Guidelines for determining flood flow
#'    frequency - Bulletin 17C" (England et al., 2019)
#'
#' @name B17C_Tab8_1
#' @docType data
#'
#' @format A data frame with 20 rows and 2 variables:
#' \describe{
#'   \item{Q_peak_Etowa_River_cfs}{name of the crop}
#'   \item{Q_peak_Suwanee_Creek_cfs}{the crop coefficient in the growth initial stage}
#   ...
#' }
#' @source England, J. F., Jr., Cohn, T. A., Faber, B. A., Stedinger, J. R., Thomas, W. O., Jr.,
#'    Veilleux, A. G., Kiang, J. E., & Mason, R. R., Jr. (2019).
#'    Guidelines for determining flood flow frequency - Bulletin 17C. U.S. Geological Survey.
NULL
#'
#' MOVE extended record for 13 years (1972-1984) for Suwanee Creek at Suwanee, Georgia
#'
#' A dataset containing the MOVE extended record for 13 years (1972-1984) for Suwanee Creek at Suwanee,
#'    Georgia (station 02334885) extracted from Table 8.2 in "Guidelines for determining flood flow
#'    frequency - Bulletin 17C" (England et al., 2019)
#'
#' @name B17C_Tab8_2
#' @docType data
#'
#' @format A data frame with 13 rows and 1 variable:
#' \describe{
#'   \item{Q_peak_cfs}{peak flows in cfs}
#   ...
#' }
#' @source England, J. F., Jr., Cohn, T. A., Faber, B. A., Stedinger, J. R., Thomas, W. O., Jr.,
#'    Veilleux, A. G., Kiang, J. E., & Mason, R. R., Jr. (2019).
#'    Guidelines for determining flood flow frequency - Bulletin 17C. U.S. Geological Survey.
NULL
#'
#' Flood records for 93 years (1892-1984) for the Etowah River at Canton, Georgia
#'
#' A dataset containing the flood records for 93 years (1892-1984) for the Etowah River at Canton,
#'    Georgia (station 02335000) extracted from Table 8.3 in "Guidelines for determining flood flow
#'    frequency - Bulletin 17C" (England et al., 2019)
#'
#' @name B17C_Tab8_3
#' @docType data
#'
#' @format A data frame with 93 rows and 1 variable:
#' \describe{
#'   \item{Q_peak_cfs}{peak flows in cfs}
#   ...
#' }
#' @source England, J. F., Jr., Cohn, T. A., Faber, B. A., Stedinger, J. R., Thomas, W. O., Jr.,
#'    Veilleux, A. G., Kiang, J. E., & Mason, R. R., Jr. (2019).
#'    Guidelines for determining flood flow frequency - Bulletin 17C. U.S. Geological Survey.
NULL
#'
#' U.S. Geological Survey gage 01134500 Moose River at Victory, Vermont annual peak-flow record during 1947-2014
#'
#' A dataset containing the U.S. Geological Survey gage 01134500 Moose River at Victory, Vermont annual
#'    peak-flow record consisting of 68 peaks from 1947 to 2014 extracted from Table 10.2 in "Guidelines for
#'    determining flood flow frequency - Bulletin 17C" (England et al., 2019)
#'
#' This table contains the date of the annual peak recorded at the gage, the water year of the annual peak,
#'    and the corresponding annual peak in cubic feet per second (ft3/s).
#'
#' @name B17C_Tab10_2
#' @docType data
#'
#' @format A data frame with 68 rows and 1 variable:
#' \describe{
#'   \item{Q_peak_cfs}{peak flows in cfs}
#   ...
#' }
#' @source England, J. F., Jr., Cohn, T. A., Faber, B. A., Stedinger, J. R., Thomas, W. O., Jr.,
#'    Veilleux, A. G., Kiang, J. E., & Mason, R. R., Jr. (2019).
#'    Guidelines for determining flood flow frequency - Bulletin 17C. U.S. Geological Survey.
NULL
#'
#' U.S. Geological Survey gage 11274500 Orestimba Creek near Newman, California annual peak-flow record
#'    during 1932-2013
#'
#' A dataset containing the U.S. Geological Survey gage 11274500 Orestimba Creek near Newman, California
#'    annual peak-flow record consisting of 82 peaks from 1932 to 2013 extracted from Table 10.6 in "Guidelines for
#'    determining flood flow frequency - Bulletin 17C" (England et al., 2019)
#'
#' This table contains the date of the annual peak recorded at the gage, the water year of the annual peak,
#'    and the corresponding annual peak in cubic feet per second (ft3/s).
#'
#' @name B17C_Tab10_6
#' @docType data
#'
#' @format A data frame with 82 rows and 1 variable:
#' \describe{
#'   \item{Q_peak_cfs}{peak flows in cfs}
#   ...
#' }
#' @source England, J. F., Jr., Cohn, T. A., Faber, B. A., Stedinger, J. R., Thomas, W. O., Jr.,
#'    Veilleux, A. G., Kiang, J. E., & Mason, R. R., Jr. (2019).
#'    Guidelines for determining flood flow frequency - Bulletin 17C. U.S. Geological Survey.
NULL
#'
#' U.S. Geological Survey gage 01614000 Back Creek near Jones Springs, West Virginia annual peak-flow record
#'    during 1929-2012
#'
#' A dataset containing the U.S. Geological Survey gage 01614000 Back Creek near Jones Springs, West Virginia
#'   annual peak-flow record consisting of 56 peaks during 1929-2012, including the 1936 historical flood, extracted
#'   from Table 10.10 in "Guidelines for determining flood flow frequency - Bulletin 17C" (England et al., 2019)
#'
#' This table contains the date of the annual peak recorded at the gage, the water year of the annual peak,
#'   and the corresponding annual peak in cubic feet per second (ft3/s).
#'
#' @name B17C_Tab10_10
#' @docType data
#'
#' @format A data frame with 56 rows and 1 variable:
#' \describe{
#'   \item{Q_peak_cfs}{peak flows in cfs}
#   ...
#' }
#' @source England, J. F., Jr., Cohn, T. A., Faber, B. A., Stedinger, J. R., Thomas, W. O., Jr.,
#'    Veilleux, A. G., Kiang, J. E., & Mason, R. R., Jr. (2019).
#'    Guidelines for determining flood flow frequency - Bulletin 17C. U.S. Geological Survey.
NULL
#'
#' U.S. Geological Survey gage 07099500 (and others) Arkansas River annual peak-flow record during 1864-1976
#'
#' A dataset containing the U.S. Geological Survey gage 07099500 (and others) Arkansas River annual peak-flow
#'    record consisting of 85 peaks from 1864 to 1976 extracted from Table 10.14 in "Guidelines for determining
#'    flood flow frequency - Bulletin 17C" (England et al., 2019)
#'
#' This table contains the water year of the annual peak and the corresponding annual peak in
#'    cubic feet per second (ft3/s).
#'
#' @name B17C_Tab10_14
#' @docType data
#'
#' @format A data frame with 85 rows and 1 variable:
#' \describe{
#'   \item{Q_peak_cfs}{peak flows in cfs}
#   ...
#' }
#' @source England, J. F., Jr., Cohn, T. A., Faber, B. A., Stedinger, J. R., Thomas, W. O., Jr.,
#'    Veilleux, A. G., Kiang, J. E., & Mason, R. R., Jr. (2019).
#'    Guidelines for determining flood flow frequency - Bulletin 17C. U.S. Geological Survey.
NULL
#'
#' U.S. Geological Survey gage 05489490 Bear Creek at Ottumwa, Iowa annual peak-flow record during 1965-2014
#'
#' A dataset containing the U.S. Geological Survey gage 05489490 Bear Creek at Ottumwa, Iowa annual peak-flow
#'    record consisting of 49 peaks from 1965 to 2014 extracted from Table 10.18 in "Guidelines for determining flood
#'    flow frequency - Bulletin 17C" (England et al., 2019)
#'
#' This table contains the date of the annual peak recorded at the gage, the water year of the annual peak,
#'    and the corresponding annual peak in cubic feet per second (ft3/s).
#'
#' @name B17C_Tab10_18
#' @docType data
#'
#' @format A data frame with 50 rows and 1 variable:
#' \describe{
#'   \item{Q_peak_cfs}{peak flows in cfs}
#   ...
#' }
#' @source England, J. F., Jr., Cohn, T. A., Faber, B. A., Stedinger, J. R., Thomas, W. O., Jr.,
#'    Veilleux, A. G., Kiang, J. E., & Mason, R. R., Jr. (2019).
#'    Guidelines for determining flood flow frequency - Bulletin 17C. U.S. Geological Survey.
NULL
#'
#' U.S. Geological Survey gage 09480000 Santa Cruz River near Lochiel, Arizona annual peak-flow record
#'    during 1949 -2013
#'
#' A dataset containing the U.S. Geological Survey gage 09480000 Santa Cruz River near Lochiel, Arizona annual
#'    peak-flow record consisting of 65 peaks from 1949 to 2013 extracted from Table 10.18 in "Guidelines for
#'    determining flood flow frequency - Bulletin 17C" (England et al., 2019)
#'
#' This table contains the date of the annual peak recorded at the gage, the water year of the annual peak, and
#'    the corresponding annual peak in cubic feet per second (ft3/s).
#'
#' @name B17C_Tab10_22
#' @docType data
#'
#' @format A data frame with 65 rows and 1 variable:
#' \describe{
#'   \item{Q_peak_cfs}{peak flows in cfs}
#   ...
#' }
#' @source England, J. F., Jr., Cohn, T. A., Faber, B. A., Stedinger, J. R., Thomas, W. O., Jr.,
#'    Veilleux, A. G., Kiang, J. E., & Mason, R. R., Jr. (2019).
#'    Guidelines for determining flood flow frequency - Bulletin 17C. U.S. Geological Survey.
NULL
#'
#' Maximum annual peak discharge values, obseved at Harricana River at Amos
#'
#' A dataset containing the Maximum annual peak discharge values in cubic meter per second (cms), observed at
#'    Harricana River at Amos (Quebec, Canada) as displayed by the program HFA extracted from Table 1.2 in
#'    "The Gamma Family and Derived Distributions Applied in Hydrology" (Bobee and Ashkar, 1991).
#'
#' @name Harricana
#' @docType data
#'
#' @format A data frame with 72 rows and 1 variable:
#' \describe{
#'   \item{Observation}{peak flows}
#   ...
#' }
#' @source Bobee, B. & Ashkar, F. (1991). \emph{The Gamma Family and Derived Distributions Applied in Hydrology}.

#'    Water Resources Publications.
NULL