% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.max.R
\name{pk.max}
\alias{pk.max}
\title{Annual maximum series}
\usage{
pk.max(TS)
}
\arguments{
\item{TS}{data.frame of streamflow time series loaded with \code{\link{read.flows}}.}
}
\value{
Returns a numeric vector containing the annual maximum flow (m3/s) 
  series, by hydrologic year. The "times" attribute contains the hydrologic year 
  for each element in the vector.
}
\description{
This function returns the annual maximum series from a daily streamflow time
series.
}
\examples{
data(caniapiscau)
cania.ts <- create.ts(caniapiscau, hyrstart = 4)
cania.ts <- drop.years(cania.ts)
cania.ts <- set.plot.titles(cania.ts, 
title.elements = c("StationID", "StnName", "StateProv"))

res <- pk.max(cania.ts)
res2 <- screen.metric(res, ylabel = "Q (m3/s)", title = TRUE)
}
\seealso{
See \code{\link{create.ts}} to format the input flow series.

  See \code{\link{pk.max.doy}} to find the day of year for each annual
  maximum flow event.
}
\author{
Jennifer Dierauer
}
