% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fluidigm-package.R
\docType{package}
\name{Fluidigm}
\alias{Fluidigm}
\alias{Fluidigm-package}
\title{Fluidigm}
\description{
Designed to streamline the process of analyzing genotyping data from Fluidigm machines, this package offers a suite of tools for data handling and analysis. It includes functions for converting Fluidigm data to format used by 'PLINK', estimating errors, calculating pairwise similarities, determining pairwise similarity loci, and generating a similarity matrix.
}
\section{Title}{

Comprehensive Analysis of Fluidigm Genotyping Data
}

\section{Description}{

A suite of tools designed to streamline the process of analyzing genotyping data from Fluidigm machines.
It includes functions for converting Fluidigm data to 'PLINK' format, estimating errors, calculating pairwise
similarities, determining pairwise similarity loci, and generating a similarity matrix.
}

\section{Details}{

The package provides a comprehensive analysis pipeline for Fluidigm genotyping data. It starts by converting
the raw data from the Fluidigm machine into a format that can be used with the 'PLINK' software. It then estimates
errors in the data, calculates pairwise similarities between genotypes, determines pairwise similarity loci,
and generates a similarity matrix. The package is designed to make it easier and more efficient for researchers
to extract meaningful insights from their genotyping studies.
}

\section{References}{

\itemize{
\item{Purcell S, Neale B, Todd-Brown K, Thomas L, Ferreira MAR, Bender D, Maller J, Sklar P, de Bakker PIW, Daly MJ & Sham PC (2007)
\emph{PLINK: a toolset for whole-genome association and population-based linkage analysis.} American Journal of Human Genetics, 81.}
\item{Purcell, Shaun. PLINK. \url{https://zzz.bwh.harvard.edu/plink/}}}
}

\author{
\strong{Maintainer}: Daniel Fischer \email{Daniel.Fischer@luke.fi} (\href{https://orcid.org/0000-0002-7513-683X}{ORCID})

Authors:
\itemize{
  \item Robert Ekblom (\href{https://orcid.org/0000-0003-2222-1966}{ORCID})
}

Other contributors:
\itemize{
  \item Helena Johansson [contributor, funder]
}

}
\keyword{fluidigm}
\keyword{genotyping}
