% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FGf.R
\name{FGf}
\alias{FGf}
\title{Four-gamete Test}
\usage{
FGf(x)
}
\arguments{
\item{x}{A properly formatted data frame. For details see '?FourgameteP'}
}
\value{
All data output files are organized based on names in the example: 
\itemize{
\item{ }{...............Locus1....Locus2}
\item{ }{ Gamete 1.......A.........A}
\item{ }{ Gamete 2.......A.........B}
\item{ }{ Gamete 3.......B.........A}
\item{ }{ Gamete 4.......B.........B}
}

Columns "Locus1" and "Locus2" in data files indicate which two columns (loci) of your data were being compared.

In data output file \strong{"TrueUnique"}, the column "Locus1A" is the first allele "A" in the column "Locus1" while "Locus2B" would indicate the second allele (B) present in the "Locus2" column. Together they make up four dilocus genotypes (or the four gametes): (Locus1A,Locus2A), (Locus1A, Locus2B), (Locus1B,Locus2A), and (Locus1B,Locus2B)

The "FourGametes?" column indicates if the program was able to find all four gametes. A value of "TRUE" indicates phylogenetic incompatibility between the tested loci. A value of “FALSE” indicates that only three or fewer gametes were found.

\strong{"FinalResults"} This file contains all locus pair comparisons and if the program was able to find any ANY combination of alleles at a locus pair for which the four gametes were found (TRUE) or if  it was only able to find three or fewer of the gametes (FALSE).

\strong{"TrueUnique"} This file contains all of the possible combination of alleles at all locus pairs for which the four gametes can be found (TRUE).

The number of monomorphic loci is stored in the value \strong{"MonoLoci"} and their identity in \strong{"NamesOfMonoLoci"}.

The total number of comparisons between loci that are not monomorphic is stored in \strong{"Comparisons"}

The number of these comparisons that were TRUE or False is stored in \strong{"ComparisonsTrue"} or in \strong{"ComparisonsFalse"} respectively.
}
\description{
The function FGf allows users to quickly assess genotypic data for phylogenetic incompatibility, a sign of recombination, using the four-gamete test.
}
\examples{
n = c(2, 3, 3, 2)
c = c(2, 2, 4, 4)
d = c(2, 5, 5, 3)
df = data.frame(n, c, d)
FGf(df)



}
