% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNPlm.R
\name{SNPlm}
\alias{SNPlm}
\title{Revised functional linear regression analysis for the sequence (genotypes) data}
\usage{
SNPlm(y, z, location, X, type1, type2, nbasis1, nbasis2, params1, params2,
  intercept = FALSE, Plot = FALSE)
}
\arguments{
\item{y}{a numeric vector specifying the response variables.}

\item{z}{a matrix specifying the scalar covariates, with the number of rows equal to the number of samples.}

\item{location}{a numeric vector defining the sampling sites of the sequence data.}

\item{X}{a matrix specifying the sequence data, with the number of rows equal to the number of samples.}

\item{type1}{a character specifying the type of the basis functions that constitutes the genetic variation function. The options are "Bspline", "Exponential", "Fourier", "Monomial", and "Power".}

\item{type2}{a character specifying the type of the basis functions that constitutes the genetic effect function. The options are "Bspline", "Exponential", "Fourier", "Monomial", and "Power".}

\item{nbasis1}{an integer specifying the number of basis functions that constitutes the genetic variation function.}

\item{nbasis2}{an integer specifying the number of basis functions that constitutes the genetic effect function.}

\item{params1}{in addition to rangeval1 (a vector of length 2 giving the lower and upper limits of the range of permissible values for the genetic variation function) and nbasis1, all bases have one or two parameters unique to that basis type or shared with one other;}

\item{params2}{in addition to rangeval1 (a vector of length 2 giving the lower and upper limits of the range of permissible values for the genetic effect function) and nbasis1, all bases have one or two parameters unique to that basis type or shared with one other;
\itemize{
\item{bspline:}{ Argument norder = the order of the spline, which is one more than the degree of the polynomials used. This defaults to 4, which gives cubic splines.}
\item{exponential:}{ Argument ratevec. In fda_2.0.2, this defaulted to 1. In fda_2.0.3, it will default to 0:1.}
\item{fourier:}{ Argument period defaults to diff(rangeval).}
\item{monomial/power:}{ Argument exponents. Default = 0:(nbasis-1). For monomial bases, exponents must be distinct nonnegative integers. For power bases, they must be distinct real numbers.}
}}

\item{intercept}{should intercept(s) be fitted (TRUE) or set to zero (default = FALSE).}

\item{Plot}{should the estimated genetic effect function beta(t) be plotted (TRUE) or not (default = FALSE).}
}
\value{
An "SNPlm" object that contains the list of the following items.
\itemize{
\item{alpha:}{ estimated intercept value.}
\item{gamma:}{ estimated coefficients of the scalar covariates.}
\item{b:}{ estimated coefficients of the chosen basis functions for the genetic effect function beta(t).}
\item{betat:}{ an "fd" object, representing the estimated genetic effect function beta(t).}
\item{residuals:}{ the residuals, that is response minus fitted values.}
\item{fitted.values: }{ the fitted mean values.}
\item{terms:}{ the terms object used.}
\item{model:}{ if requested (the default), the model frame used.}
\item{para:}{ some relevant parameters of "SNPlm" model.}
}
}
\description{
This function models the genetic effect of genetic variants by relating the genetic variant function to the phenotype adjusting for covariates.
}
\examples{
library(FunctanSNP)
n <- 300
m <- 30
simdata1 <- simData1(n, m, seed = 123)
y <- simdata1$y
z <- simdata1$z
location <- simdata1$location
X <- simdata1$X
SNPlmres <- SNPlm(y, z, location, X, type1 = "Bspline", type2 = "Bspline", nbasis1 = 5,
                  nbasis2 = 5, params1 = 4, params2 = 4, intercept = FALSE, Plot = TRUE)
SNPlmres$alpha
SNPlmres$gamma
SNPlmres$b
}
\seealso{
See Also as \code{\link{SNPgvf}}.
}
