% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictSNPreg.R
\name{predictSNPreg}
\alias{predictSNPreg}
\title{Make predictions from an SNPlm or SNPinter object}
\usage{
predictSNPreg(x, newz, newX)
}
\arguments{
\item{x}{an "SNPlm"/"SNPinter" object obtained by \code{\link{SNPlm}}/\code{\link{SNPinter}}.}

\item{newz}{matrix of new values for z at which predictions are to be made.}

\item{newX}{matrix of new values for X at which predictions are to be made.}
}
\value{
\itemize{
\item{predicted.values: }{ the predicted mean values.}
}
}
\description{
This functions predicts fitted values for newly entered data from a fitted "SNPlm" or "SNPinter" object.
}
\examples{
library(FunctanSNP)
n <- 300
m <- 30
simdata1 <- simData1(n, m, seed = 123)
SNPlmres <- SNPlm(y = simdata1$y[1:200], z = simdata1$z[1:200, ],
                  location = simdata1$location, X = simdata1$X[1:200, ],
                  type1 = "Bspline", type2 = "Bspline", nbasis1 = 5,
                  nbasis2 = 5, params1 = 4, params2 = 4, intercept = FALSE,
                  Plot = FALSE)
predict.values1 <- predictSNPreg(x = SNPlmres, newz = simdata1$z[-(1:200), ],
                                 newX = simdata1$X[-(1:200), ])

simdata2 <- simData2(n, m, seed = 123)
lambda1 <- 0.05
lambda2 <- sqrt(3)*lambda1
eta <- 0
SNPinterres <- SNPinter(y = simdata2$y[1:200], z = simdata2$z[1:200, ],
                        location = simdata2$location, X = simdata2$X[1:200, ],
                        lambda1, lambda2, eta, type1 = "Bspline",
                        nbasis1 = 5, params1 = 4, Bsplines = 5, norder = 4,
                        intercept = TRUE, eps = 1e-2, maxstep = 1e2, Plot = FALSE)
predict.values2 <- predictSNPreg(x = SNPinterres, newz = simdata2$z[-(1:200), ],
                                 newX = simdata2$X[-(1:200), ])

}
\seealso{
See Also as \code{\link{SNPlm}}, \code{\link{SNPinter}}.
}
