% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Japan.R
\docType{data}
\name{Japan}
\alias{Japan}
\title{Helminth communities of so-iuy mullets from the Japan Sea}
\format{
A data frame with 192 rows and 22 columns. The first column (sample)
    is a survey identifier. The remaining columns correspond to species
    abundances. See source for species abbreviations and survey identifiers.
}
\source{
Llopis-Belenguer, C. (2019) Replication data for: Native and invasive hosts
    play different roles in host-parasite networks, Harvard Dataverse,
    \doi{10.7910/DVN/IWIKOL}.
}
\usage{
data(Japan)
}
\description{
Abundance of 21 helminth species from 192 so-iuy mullets collected in the
    Japan Sea. Fish are grouped in seven surveys.
}
\examples{
data(Azov)
# Apply the FuzzyQ algorithm to each survey:
fuzzyq.japan <- by(Japan[, -1], Japan[, "sample"], fuzzyq, rm.absent = FALSE)
# Get cluster membership, silhouette widths and commonness indices
# per sp. per survey:
spp.japan <- lapply(fuzzyq.japan, function(x) x$spp)
# Get global silhouette withds, commonness indices and Dunn's normalized
# partition coefficient per survey:
global.japan <- t(sapply(fuzzyq.japan, function(x) x$global))

}
\references{
Llopis-Belenguer, C., Blasco-Costa, I., Balbuena, J.A.,
    Sarabeev, V., Stouffer, D.B. (2020), Native and invasive hosts play
    different roles in host-parasite networks. Ecography, 43: 559-568.
    \doi{10.1111/ecog.04963}.
}
\keyword{datasets}
