\name{FuzzyStatTra-package}
\alias{FuzzyStatTra-package}
\alias{FuzzyStatTra}
\docType{package}
\title{
Statistical Methods for Trapezoidal Fuzzy Numbers
}
\description{
The aim of the package is to provide some basic functions for doing statistics with trapezoidal fuzzy numbers.
}
\details{
\tabular{ll}{
Package: \tab FuzzyStatTra\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2016-02-07\cr
License: \tab GPL (>=2)\cr
}
The aim of the package is to provide some basic functions for doing statistics with trapezoidal fuzzy numbers. In particular, the package contains several functions for simulating trapezoidal fuzzy numbers, as well as for calculating some central tendency measures (mean and two types of median), some scale measures (variance, ADD, MDD, Sn, Qn, Tn and some M-estimators) and one diversity index and one inequality index. Moreover, functions for calculating the 1-norm distance, the mid/spr distance and the \eqn{(\varphi,\theta)}-wabl/ldev/rdev distance between fuzzy numbers are included, and a function to calculate the value \eqn{\varphi}-wabl given a sample of trapezoidal fuzzy numbers.
}
\author{
Asun Lubiano <lubiano@uniovi.es>, Sara de la Rosa de Saa  <rosasara@uniovi.es>

Maintainer: Asun Lubiano <lubiano@uniovi.es>
}
\references{
 [1] Blanco-Fernandez, A.; Casals, R.M.; Colubi, A.; Corral, N.; Garcia-Barzana, M.; Gil, M.A.; Gonzalez-Rodriguez, G.; Lopez, M.T.; Lubiano, M.A.; Montenegro, M.; Ramos-Guajardo, A.B.; de la Rosa de Saa, S.; Sinova, B.: \emph{Random fuzzy sets: A mathematical tool to develop statistical fuzzy data analysis}, Iranian Journal on Fuzzy Systems 10(2), pp. 1-28 (2013)
 
 [2] De la Rosa de Saa, S.; Gil, M.A.; Gonzalez-Rodriguez, G.; Lopez, M.T.; Lubiano M.A.: \emph{Fuzzy rating scale-based questionnaires and their statistical analysis}, IEEE Trans. Fuzzy Syst. 23(1), pp. 111-126 (2015) 
 
 [3] De la Rosa de Saa, S.; Lubiano M.A.; Sinova, B.; Filzmoser, P.: \emph{Robust scale estimators for fuzzy data}, Advances in Data Analysis and Classification, pp. 1-28 (2015) 
 
 [4] Diamond, P.; Kloeden, P.: \emph{Metric spaces of fuzzy sets}, Fuzzy Sets Syst. 35, pp. 241-249 (1990)
 
 [5] Gil, M.A.; Lubiano, M.A.; De la Rosa de Saa, S.; Sinova, B.: \emph{Analyzing data from a fuzzy rating scale-based questionnaire. A case study}, Psicothema 27(2), pp. 182-191 (2015)
 
 [6] Lubiano, M.A.; Gil, M.A.: \emph{f-Inequality indices for fuzzy random variables}, in Statistical Modeling, Analysis and Management of Fuzzy Data (Bertoluzza, C., Gil, M.A., Ralescu, D.A., Eds.), Physica-Verlag, pp. 43-63 (2002)
 
 [7] Lubiano, M.A.; De la Rosa de Saa, S.; Montenegro, M.; Sinova, B.; Gil, M.A.: \emph{Descriptive analysis of responses to items in questionnaires. Why not a fuzzy rating scale?}, Information Sciences 360, pp. 131-148 (2016)
 
 [8] Lubiano, M.A.; Montenegro, M.; Sinova, B.; De la Rosa de Saa, S.; Gil, M.A.: \emph{Hypothesis testing for means in connection with fuzzy rating scale-based data: algorithms and applications}, European Journal of Operational Research 251, pp. 918-929 (2016)
 
 [9] Sinova, B.; Gil, M.A.; Colubi, A.; Van Aelst, S.: \emph{The median of a random fuzzy number. The 1-norm distance approach}, Fuzzy Sets Syst. 200, pp. 99-115 (2012)
 
 [10] Sinova, B.; de la Rosa de Saa, S.; Gil, M.A.: \emph{A generalized L1-type metric between fuzzy numbers for an approach to central tendency of fuzzy data}, Information Sciences 242, pp. 22-34 (2013)
 
 [11] Sinova, B.; Gil, M.A.; Lopez, M.T.; Van Aelst, S.: \emph{A parameterized L2 metric between fuzzy numbers and its parameter interpretation}, Fuzzy Sets and Systems 245, pp. 101-115 (2014)
 
 [12] Sinova, B.; De la Rosa de Saa, S.; Lubiano, M.A.; Gil, M.A.: \emph{An overview on the statistical central tendency for fuzzy datasets}, International Journal of Uncertainty, Fuzziness and Knowledge-Based Systems 23 (Suppl. 1), pp. 105-132 (2015)
 
 [13] Sinova, B.; Gil, M.A.; Van Aelst, S.: \emph{M-estimates of location for the robust central tendency of fuzzy data}, IEEE Transactions on Fuzzy Systems 24(4), pp. 945-956 (2016)
}
\keyword{ package }
\seealso{
\url{http://bellman.ciencias.uniovi.es/SMIRE/}
}