% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RealizedEst.R
\name{RealizedEst}
\alias{RealizedEst}
\title{Realized GARCH-Ito Model}
\usage{
RealizedEst(RV = RV, JV = NULL)
}
\arguments{
\item{RV}{Time series of daily realized volatilities.}

\item{JV}{Time series of daily jump variations,}
}
\value{
Estimated parameter values and daily conditional volatilities:
\describe{
\item{coefficients}{parameter estimates of the realized GARCH-Ito model}
\item{sigma}{daily conditional volatility estimates of the realized GARCH-Ito model}
\item{pred}{one-step-ahead predicted volatility value}
}
}
\description{
Estimate model parameters for the Realized GARCH-Ito Model
}
\examples{
sample_data
RealizedEst(sample_data$RV)
RealizedEst(sample_data$BPV, sample_data$JV)
}
\references{
Song, X., Kim, D., Yuan, H., Cui, X., Lu, Z., Zhou, Y., & Wang, Y. (2020).
Volatility Analysis with Realized GARCH-Ito Models. Journal of Econometrics, in press.
}
