% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{panel2list}
\alias{panel2list}
\title{data.frame to list of data matrices}
\usage{
panel2list(
  panel,
  depvar_header = NULL,
  i_header = NULL,
  j_header = NULL,
  t_header = NULL
)
}
\arguments{
\item{panel}{The user-supplied data frame for the multilevel panel data. See \strong{Details}.}

\item{depvar_header}{A character string specifying the header of the dependent variable. See \strong{Details}.}

\item{i_header}{A character string specifying the header of the block identifier. See \strong{Details}.}

\item{j_header}{A character string specifying the header of the individual identifier. See \strong{Details}.}

\item{t_header}{A character string specifying the header of the time identifier. See \strong{Details}.}
}
\value{
A list containing the data matrices of the \eqn{R} blocks. Each of them
has dimension \eqn{T\times N_{i}}.
}
\description{
This function converts the data.frame to a list of data matrices and finds
the dimensions of the multilevel panel.
}
\details{
See the details of GCC().
}
\examples{

panel <- UKhouse # load the data

# panel$Region identifies different blocks i=1,...,R.
# panel$LPA_Type identifies different individuals j=1,...,N_i.

Y_list<- panel2list(panel, depvar_header = "dlPrice", i_header = "Region",
                                       j_header = "LPA_Type", t_header = "Date")

}
