% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmgceclassfunctions.R
\name{fitted.lmgce}
\alias{fitted.lmgce}
\title{Calculate \code{\link{lmgce}} Fitted Values}
\usage{
\method{fitted}{lmgce}(object, ...)
}
\arguments{
\item{object}{Fitted \code{\link{lmgce}} model object.}

\item{...}{additional arguments.}
}
\value{
Returns a vector with the fitted values for the linear model
represented by a \code{\link{lmgce}} object.
}
\description{
The fitted values for the linear model represented by a \code{\link{lmgce}}
object are extracted.
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)
}
fitted(res_gce_package)

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
