% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryHS.R
\name{summaryHS}
\alias{summaryHS}
\title{Summary function of Hierarchical Spike}
\usage{
summaryHS(object)
}
\arguments{
\item{object}{a result of a call to HS}
}
\value{
\itemize{
\item Name of Gene: the component from object.
\item Number of SNPs: the component from object.
\item Name of SNPs: the component from object.
\item Pleiotropic effect based on CI: the component from object.
\item Pleiotropic effect based on median thresholding: the component from object.
}
}
\description{
The summaryHS function serves as a versatile tool for generating result summaries derived from the output of the HS function.
}
\examples{
# PARP2_summary
data(PARP2_summary)
Breast <- PARP2_summary$Breast
Thyroid <- PARP2_summary$Thyroid
Betah <- list(Breast$beta, Thyroid$beta)
Sigmah <- list(diag(Breast$se), diag(Thyroid$se))
genename <- "PARP2"
snpnames <- Breast$snp
K <- 2
m <- 6

set.seed(123)
RES <- HS(Betah, Sigmah,
  kappa0 = 0.5, kappastar0 = 0.5, sigma20 = 1, s20 = 1,
  m = m, K = K, niter = 800, burnin = 400, nthin = 1, nchains = 1,
  a1 = 0.1, a2 = 0.1, d1 = 0.1, d2 = 0.1, c1 = 1, c2 = 1, e2 = 1, snpnames, genename
)
summaryHS(RES)
}
\references{
Baghfalaki, T., Sugier, P. E., Truong, T., Pettitt, A. N., Mengersen, K., & Liquet, B. (2021). Bayesian meta analysis models for cross cancer genomic investigation of pleiotropic effects using group structure. Statistics in Medicine, 40(6), 1498-1518.
}
\author{
Taban Baghfalaki.
}
