% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_score.R
\name{z_score}
\alias{z_score}
\title{Transform values into z scores}
\usage{
z_score(xvals, mu = FALSE, sigma = FALSE)
}
\arguments{
\item{xvals}{vector of numbers}

\item{mu}{the population mean}

\item{sigma}{the population standard deviation}
}
\value{
a numeric vector of z scores
}
\description{
`z_score` transforms input values to z scores. Allows user input of mu and sigma values for comparing distributions.
}
\examples{
# Format data
df.new <- format_data(GCaMP)

# Split data
basevals <- df.new$Trial1[df.new$Time <= 0]
eventvals <- df.new$Trial1[df.new$Time > 0]

# Find baseline (pre-epoc) values
base.mu <- mean(basevals)
base.sigma <- sd(basevals)

# Compute values
z_score(x = eventvals, mu = base.mu, sigma = base.sigma)
}
