\name{dataDSS}
\alias{dataDSS}
\docType{data}

\title{Simulated data with double sample selection}

\description{Simulated data with double sample selection and binary outcome.}

\usage{
data(dataDSS)
}


\format{\code{dataDSS} is a 10000 row data frame with the following columns: 

\describe{
         
\item{y1}{First selection.}
\item{y2}{Second selection.}
\item{y3}{Binary outcome.}
\item{x1, x2}{Covariates.}
\item{x3}{Covariate influencing only \code{y1}.}
\item{x4}{Covariate influencing only \code{y2}.}
\item{y3.o}{Original outcome, without missingness.}


}

}

\examples{

# Data have been simulated as shown below

n  <- 10000
x1 <- round(runif(n))
x2 <- runif(n)
x3 <- runif(n)
x4 <- rnorm(n)
u  <- rnorm(n)

y1 <- ifelse(-1.55 +     x1 - x2 + x3 + u + rnorm(n) > 0, 1, 0)
y2 <- ifelse(-0.25 - 0.5*x1 + x2 + x4 + u + rnorm(n) > 0, 1, 0)
y3 <- y3.o <- ifelse( -0.75 + x1 + x2 + u + rnorm(n) > 0, 1, 0)

y2 <- y2*y1
y3 <- y3*y2
y3 <- ifelse(y2 == 0, NA, y3)

dataDSS <- data.frame(y1, y2, y3, x1, x2, x3, x4, y3.o)

}



