% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_meas.R
\name{evalMeas}
\alias{evalMeas}
\title{Evaluation measures when complete data is available}
\usage{
evalMeas(missbp, compdat = NULL)
}
\arguments{
\item{missbp}{An object of class \code{missbp} obtained from preceding function \code{missmi()}.}

\item{compdat}{Complete data matrix representing the input data of \code{missmi()}}
}
\value{
The \code{missbp} object is appended with the following objects:
\item{eval}{Returns a data table with five evaluation measures: Procrustes Statistic (PS), Similarity Proportion (SP), Response Profile Recovery (RPR), Absolute Mean Bias (AMB), Root Mean Squared Bias (RMSB)}
\item{GPApred}{A dataframe representing predicted categorical responses from the GPAbin biplot.}
\item{compPred}{A dataframe representing predicted categorical responses from the complete MCA biplot.}
\item{compZs}{Sample coordinates for the MCA biplot of the complete data.}
\item{compCLPs}{CLPs for the MCA biplot of the complete data.}
\item{complvls}{Names of the CLPs for the MCA biplot of the complete data.}

See also \code{\link{missmi}}, \code{\link{impute}}, \code{\link{DRT}} and \code{\link{GPAbin}}.

For more detail, refer to Nienkemper-Swanepoel, J., le Roux, N. J., & Gardner-Lubbe, S. (2021). GPAbin: unifying visualizations of multiple imputations for missing values. Communications in Statistics - Simulation and Computation, 52(6), 2666–2685. https://doi.org/10.1080/03610918.2021.1914089.
}
\description{
Calculates measures of comparison based on distances between two configurations in two dimensions.
}
\examples{
\donttest{
data(compdat)
data(implist)
missbp <- missmi(implist) |> DRT() |> GPAbin() |> evalMeas(compdat=compdat)}

}
