% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpcmStruct.R
\name{predict}
\alias{predict}
\alias{predict.gpcm}
\alias{predict,gpcm-method}
\title{Predict class probability at newdata for a Gaussian Process Classification (GPC) model}
\usage{
\method{predict}{gpcm}(object, newdata, nsimu = NULL, 
light.return = FALSE, checkNames=FALSE, seed = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{gpcm}.}

\item{newdata}{a vector, matrix of points to be predicted.}

\item{nsimu}{an optional integer indicating whether to resample latent GP at observation points and how many samples are required. If \code{NULL}, current samples are used. Default is \code{NULL}.}

\item{light.return}{an optional boolean. If \code{TRUE}, only \code{prob} is returned. Default is \code{FALSE}.}

\item{checkNames}{an optional boolean. If \code{TRUE}, a consistency test is performed between the names of newdata and the names of the experimental design (contained in \code{object@Xf}). Default is \code{FALSE}.}

\item{seed}{to fix the seed (used if \code{nsimu} is not \code{NULL}). Default is \code{NULL}.}

\item{...}{no other argument for this method}
}
\value{
\item{prob}{the (averaged) probability of class 1 at \code{newdata}.}
\item{lower95, upper95}{ 95\% confidence bounds for the probability at \code{newdata}.}
\item{probs}{a matrix of sample predicted probabilities.}
\item{Zsimu_var, Zsimu_mean}{conditional variance vector and mean matrix of the latent GP at \code{newdata}.}
\item{cov}{conditional covariance matrix at \code{newdata}.}
\item{c}{an auxiliary matrix, containing all the covariances between \code{newdata} and design points \code{Xf}.}
\item{lambda}{an auxiliary vector, product of the inverse covariance matrix \code{invK} returned by \code{object} and the unconditional covariance matrix \code{c} between \code{newdata} and design points \code{Xf}.}
\item{kz}{an auxiliary matrix, corresponding to the unconditional covariance matrix at \code{newdata}.}
}
\description{
Predicted probability of class 1. Optionally, conditional covariance based on a \code{gpcm} model and 95\% quantiles of the probability of class 1 are returned.
}
\examples{
# ----------------------------------
# A 2D example - Branin-Hoo function
# ----------------------------------

# 30-points DoE, and the corresponding response
d <- 2
nb_PX <- 30
require(DiceDesign)
X <- lhsDesign(nb_PX, d, seed = 123)$design
Xopt <- maximinSA_LHS(X, T0 = 10, c = 0.99, it = 1000)
x <- Xopt$design
require(DiceKriging)
fx <- apply(x, 1, branin)
s <- ifelse(fx < 14, -1, 1)
f <- s
Xf <- as.matrix(x)

# Bulding GPC model
GPCmodel <- gpcm(f = f, Xf = Xf, coef.m = -0.1, coef.cov=c(0.8,0.5))

# Graphics - Predict probabilities
ngrid <- 50
x.grid <- seq(0, 1., length.out = ngrid)
grid <- as.matrix(expand.grid(x.grid, x.grid))
probabilities <- predict(object = GPCmodel, newdata = grid)$prob
filled.contour(x.grid, x.grid, matrix(probabilities, ngrid, ngrid),
               color.palette = function(n) hcl.colors(n, "RdYlBu", rev = FALSE),
               main = "probabilities map",
               plot.axes = {
                 axis(1)
                 axis(2)
                 points(Xf[f == 1, 1], Xf[f == 1, 2], col = "blue", pch = 21, bg = "blue")
                 points(Xf[f == -1, 1], Xf[f == -1, 2], col = "red", pch = 21, bg = "red")
               }
)
}
\references{
Bachoc, F., Helbert, C. & Picheny, V. Gaussian process optimization with failures: classification and convergence proof. \emph{J Glob Optim} \bold{78}, 483–506 (2020). \doi{10.1007/s10898-020-00920-0}.

Roustant, O., Ginsbourger, D. & Deville, Y. Contributors: Chevalier, C. , Richet, Y. DiceKriging: Kriging Methods for Computer Experiments. R package version 1.6.0. \url{https://CRAN.R-project.org/package=DiceKriging}.
}
\author{
Morgane MENZ, Céline HELBERT, Victor PICHENY, François BACHOC. Contributors: Naoual SERRAJI.
}
