% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoGPoMoTest.R
\name{autoGPoMoTest}
\alias{autoGPoMoTest}
\title{Tests the numerical integrability of models and
classify their dynamical regime}
\usage{
autoGPoMoTest(
  data,
  nVar,
  dMax,
  dMin = 0,
  tin = NULL,
  dt = NULL,
  show = 1,
  verbose = 1,
  allKL = allKL,
  numValidIC = 1,
  weight = NULL,
  IstepMin = 10,
  IstepMax = 10000,
  tooFarThr = 4,
  FxPtThr = 1e-08,
  LimCyclThr = 1e-06,
  method = "rk4"
)
}
\arguments{
\item{data}{Input Time series: Each column is one time series
that corresponds to one variable.}

\item{nVar}{Number of variables considered in the polynomial formulation.}

\item{dMax}{Maximum degree of the polynomial formulation.}

\item{dMin}{The minimum negative degree of the polynomial
formulation (0 by default).}

\item{tin}{Input date vector which length should correspond to
the input time series.}

\item{dt}{Sampling time of the input time series.}

\item{show}{Provide (2) or not (0-1) visual output during
the running process.}

\item{verbose}{Gives information (if set to 1) about the algorithm
progress and keeps silent if set to 0.}

\item{allKL}{A list of all the models \code{$mToTest1},
\code{$mToTest2}, etc. to be tested. Each model is provided
as a matrix.}

\item{numValidIC}{Line number of the first valid initial
conditions, that is, such as weight is not equal to zero.}

\item{weight}{A vector providing the binary weighting function
of the input data series (0 or 1). By default, all the values
are set to 1.}

\item{IstepMin}{The minimum number of integration step to start
of the analysis (by default \code{IstepMin = 10}).}

\item{IstepMax}{The maximum number of integration steps for
stopping the analysis (by default \code{IstepMax = 10000}).}

\item{tooFarThr}{Divergence threshold, maximum value
of the model trajectory compared to the data standard
deviation. By default a trjactory is too far if
the distance to the center is larger than four times the variance
of the input data.}

\item{FxPtThr}{Threshold used to detect fixed points.}

\item{LimCyclThr}{Threshold used to detect the limit cycle.}

\item{method}{The integration technique used for the numerical
integration. By default, the fourth-order Runge-Kutta method
(\code{method = 'rk4'}) is used. Other methods such as 'ode45'
or 'lsoda' may also be chosen. See package \code{deSolve}
for details.}
}
\value{
A list containing:

\code{$okMod}      A vector classifying the models: diverging models (0),
periodic models of period-1 (-1), unclassified models (1).

\code{$okMod}      A matrix classifying the model variables: diverging variable (0),
period-1 variable (-1), period-2 variable (-2), fixed point variable (2), unclassified models (1).

\code{$coeff}      A matrix with the coefficients of one selected model

\code{$models}     A list of all the models to be tested \code{$mToTest1},
\code{$mToTest2}, etc. and of all selected models \code{$model1}, \code{$model2}, etc.

\code{$tout}       The time vector of the output time series (vector length
corresponding to the longest numerical integration duration)

\code{$stockoutreg} A list of matrices with the integrated trajectories
(variable \code{X1} in column 1, \code{X2} in 2, etc.) for all the models
\code{$model1}, \code{$model2}, etc.
}
\description{
Tests the numerical integrability of
provided models (these may have been obtained with
function \code{autoGPoMoSearch}),
and classify these models as Divergent, Fixed Points,
Periodic or not Unclassified (potentially chaotic).
}
\examples{
#Example
# Load data:
data('RosYco')
# Structure choice
data('allToTest')
# Test the models
outGPT <- autoGPoMoTest(RosYco, nVar= 3, dMax = 2, dt = 1/125, show=1,
                        allKL = allToTest, IstepMax = 60)

}
\seealso{
\code{\link{autoGPoMoSearch}}, \code{\link{gPoMo}}, \code{\link{poLabs}}
}
\author{
Sylvain Mangiarotti, Flavie Le Jean
}
