% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen_plots.R
\name{nutrient_tserie_darea}
\alias{nutrient_tserie_darea}
\title{Output load time series plot}
\usage{
nutrient_tserie_darea(green_file, sh_file, basin_name)
}
\arguments{
\item{green_file}{data frame. Nutrient Load by source apportionment of
nutrient for each year and catchments.}

\item{sh_file}{sf object. The spatial information.}

\item{basin_name}{character. The title of the plot.}
}
\value{
No return value, called for the side effect of drawing a plot
}
\description{
Creates a time series plot showing basin model results
}
\examples{
\donttest{
# the data of the TN scenario
data(catch_data_TN)
data(annual_data_TN)
data(sh_file)
# the parameter to assess the basin model
alpha_p <- 35.09
alpha_l <- 0.02
sd_coef <- 0.2
# years in which the model should be executed
loc_years <- 1990:2018
# Computing the source apportionment
basin_sa <- green_shares(catch_data_TN, annual_data_TN, alpha_p, alpha_l,
sd_coef, loc_years)
basin_name <- "Visla Basin"
nutrient_tserie_darea(basin_sa, sh_file, basin_name)
}

}
