% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen.R
\name{region_nut_balance}
\alias{region_nut_balance}
\title{Nutrient balance based in the application of the Geospatial Regression
Equation returning the diffuse, land retention, point sources}
\usage{
region_nut_balance(
  catch_data,
  annual_data,
  alpha_p,
  alpha_l,
  sd_coef,
  loc_years,
  atm_coeff = 0.38
)
}
\arguments{
\item{catch_data}{data frame. Definition of the topological sequence of
catchments.}

\item{annual_data}{data frame. Sources of nutrient for each year and
catchments.}

\item{alpha_p}{numeric. First model parameter, the basin retention
coefficient.}

\item{alpha_l}{numeric. Second model parameter, the river retention
coefficient.}

\item{sd_coef}{numeric. Third model parameter, fraction of domestic diffuse
sources that reaches the stream network.}

\item{loc_years}{integer. Years in which the model should be executed.}

\item{atm_coeff}{numeric. A value for atmospheric attenuation coefficient.}
}
\value{
One object, a data frame with the basin nutrient balance
}
\description{
Computes the basin nutrient balance.
}
\examples{
\donttest{
# the data of the TN scenario
data(catch_data_TN)
data(annual_data_TN)
# the parameter to assess the basin model
alpha_p <- 35.09
alpha_l <- 0.02
sd_coef <- 0.2
# year in which the model should be executed
loc_years <- 1990:2018
# Computing the nutrient balance
basin_loads_b <- region_nut_balance(catch_data_TN, annual_data_TN, alpha_p, alpha_l,
sd_coef, loc_years)
}

}
