% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen_plots.R
\name{scatter_plot}
\alias{scatter_plot}
\title{Scatter plot of goodness-of-fit metric vs parameters}
\usage{
scatter_plot(df_cb, param)
}
\arguments{
\item{df_cb}{data frame. A table with the result of the calibration process.}

\item{param}{character. Goodness of fit metric:"NSE", "rNSE", "NSE",
"mNSE", "MAE", "PBIAS", "cp", "R2",...}
}
\value{
Multiple scatter plot
}
\description{
Scatter plot of goodness-of-fit metric vs parameters
}
\examples{
\donttest{
# the data of the TN scenario
data(catch_data_TN)
data(annual_data_TN)
# the parameter for the calibration of the model
n_iter <- 2 # number of iterations
# the lower limits for all params (alpha_P, alpha_L, sd_coef)
low <- c(10, 0.000, 0.1)
# the upper limits for all params (alpha_P, alpha_L, sd_coef)
upp <- c(70, 0.3,  0.9)
# years in which the model should be executed
years <- 1990:2018
# execution of the calibration
df_calib <- calib_green(catch_data_TN, annual_data_TN, n_iter, low, upp,
years)
gof_mes <- "NSE"
scatter_plot(df_calib, gof_mes)
}

}
