% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grin.oncoprint.mtx.R
\name{grin.oncoprint.mtx}
\alias{grin.oncoprint.mtx}
\title{GRIN OncoPrint-Compatible Lesion Matrix}
\usage{
grin.oncoprint.mtx(grin.res, oncoprint.genes)
}
\arguments{
\item{grin.res}{A data frame of GRIN results, typically generated by the \code{\link{grin.stats}} function.}

\item{oncoprint.genes}{A character vector of Ensembl gene IDs specifying the genes to include in the OncoPrint.}
}
\value{
A binary data frame (matrix) of dimensions \code{length(oncoprint.genes)} and \code{number of patients}, suitable for use with the \code{oncoPrint()} function.
}
\description{
Prepares a binary lesion matrix based on GRIN analysis results that can be directly used as input for the \code{oncoPrint} function from the \pkg{ComplexHeatmap} package. This matrix summarizes the presence or absence of lesion types across patients for a user-defined list of genes.
}
\details{
This function filters the GRIN results for a specified set of genes (using their Ensembl IDs), and constructs a gene-by-patient binary matrix indicating the presence of one or more lesion types per gene. Each row represents a gene, each column a patient, and the matrix values reflect whether that gene is affected by any lesion in the given patient.

The output matrix is fully compatible with the \code{oncoPrint()} function from the \pkg{ComplexHeatmap} package and allows visualization of lesion patterns across a defined gene set.

This is particularly useful for visualizing mutation, copy number alterations and other structural rearrangements in driver genes or genes selected by statistical criteria (e.g., significance threshold from GRIN results).
}
\examples{
data(lesion_data)
data(hg38_gene_annotation)
data(hg38_chrom_size)

# Run GRIN analysis
grin.results <- grin.stats(lesion_data,
                           hg38_gene_annotation,
                           hg38_chrom_size)

# Define a list of genes (using Ensembl IDs) to include in the OncoPrint
oncoprint.genes <- c("ENSG00000148400", "ENSG00000171862", "ENSG00000171843",
                     "ENSG00000156531", "ENSG00000162367", "ENSG00000096968",
                     "ENSG00000105639", "ENSG00000118513", "ENSG00000102974",
                     "ENSG00000133703")

# Alternatively, select genes with multiple lesion types and significant q-values
genes.const <- grin.results$gene.hits[grin.results$gene.hits$q2.nsubj < 0.01, ]
selected.genes <- as.vector(genes.const$gene)

# Generate OncoPrint-compatible lesion matrix
oncoprint.mtx <- grin.oncoprint.mtx(grin.results, oncoprint.genes)
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{grin.stats}}, \code{\link[ComplexHeatmap]{oncoPrint}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
