#' Theoretical CDF for RCAG for a given number of vertices.
#'
#' Computes the theoretical CDF for an RCAG with for a given number of vertices.
#'
#' @param m Number of observations.
#' @return A vector representing the theoretical CDF of an RCAG with m/2 vertices.
#' @examples
#' cdf.rcag(1000) 
#' @export
cdf.rcag <- function(m) {
  nv <- m %/% 2
  xx <- seq(0, 0.999, length.out = nv)
  cdf_t <- rep(0, length(xx))
  for (k in xx) {
    if (k > 0.5)
      cdf_t[which(xx == k)] <- 2.5 - 2 * sqrt(2 * (1 - k)) - k - 0.5 * (1 - sqrt(2 * (1 - k)))^2
    else
      cdf_t[which(xx == k)] <- 0
  }
  return(cdf_t)
}
