% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deg.rcag.R
\name{deg.rcag}
\alias{deg.rcag}
\title{Degree Calculation for Random Circular Graph}
\usage{
deg.rcag(theta)
}
\arguments{
\item{theta}{A numeric vector of length m=2*nv.}
}
\value{
A vector of degrees for each vertex of RCAG obtained using theta.
}
\description{
Computes the degree of each vertex in a Random Circular Graph based on input arcs.
}
\examples{
x <- arima.sim(model = list(ar=0.9), 1000) ## AR(1) model
theta <- ((2*atan(x))\%\%(2*pi))*(180/pi) ##LAR(1) model
deg.rcag(theta)
}
