% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPSC.R
\name{dTPSC}
\alias{dTPSC}
\alias{rTPSC}
\title{The TPSC-Student-t Distribution}
\usage{
dTPSC(x, w, theta, sigma, delta)

rTPSC(n, w, theta, sigma, delta)
}
\arguments{
\item{x}{vector of quantiles.}

\item{w}{vector of weight parameters.}

\item{theta}{vector of the location parameters.}

\item{sigma}{vector of the scale parameters.}

\item{delta}{the degree of freedom.}

\item{n}{number of observations.}
}
\value{
\code{dTPSC} gives the density. \code{rTPSC} generates random deviates.
}
\description{
The TPSC-Student-t Distribution
}
\details{
The TPSC-Student-t distribution has the density
\deqn{f_{\mathrm{TPSC}}(y \mid w, \theta, \sigma, \delta)=w f_{\mathrm{LT}}\left(y \mid \theta, \sigma \sqrt{\frac{w}{1-w}}, \delta\right)+(1-w) f_{\mathrm{RT}}\left(y \mid \theta, \sigma \sqrt{\frac{1-w}{w}}, \delta\right),}
where \deqn{f_{\mathrm{LT}}(y \mid \theta, \sigma, \delta)=\frac{2}{\sigma} f\left(\left.\frac{y-\theta}{\sigma} \right\rvert\, \delta\right) \mathbb{I}(y<\theta),} and \deqn{f_{\mathrm{RT}}(y \mid \theta, \sigma, \delta)=\frac{2}{\sigma} f\left(\left.\frac{y-\theta}{\sigma} \right\rvert\, \delta\right) \mathbb{I}(y \geq \theta).}
Additionally, \eqn{f(y \mid \delta)} represents the density function of the standardized Student-t distribution with the degree of freedom \eqn{\delta}.
}
\examples{
set.seed(100)
require(graphics)

# Random Number Generation
X <- rTPSC(n = 1e5,w = 0.7,theta = -1,sigma = 3,delta = 5)

# Plot the histogram
hist(X, breaks = 100, freq = FALSE)

# The red dashed line should match the underlining histogram
points(x = seq(-70,50,length.out = 1000),
       y = dTPSC(x = seq(-70,50,length.out = 1000),
                 w = 0.7,theta = -1,sigma = 3,delta = 5),
       type = "l",
       col = "red",
       lwd = 3,
       lty = 2)
}
\references{
\insertRef{liu2022bayesian}{GUD}
}
