% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWRLASSO_gaussian.R
\name{GWRLASSO_gaussian}
\alias{GWRLASSO_gaussian}
\title{GWRLASSO: a hybrid model that uses the LASSO model for important variable selection and GWR model with gaussian kernel for prediction at an unknown location based on the selected variables.}
\usage{
GWRLASSO_gaussian(data_sp, bw, split_value, gaussian_kernel, nfolds)
}
\arguments{
\item{data_sp}{A dataframe containing the response variable and the predictor variables, as well as the coordinates of the locations. In the dataframe, first column is the response variable (y), last two columns are coordinates i.e., Latitude and Longitudes and in between them is the set of predictor variables(X's).}

\item{bw}{A numeric value specifying the bandwidth parameter for the GWR model. It can be noted that, optimum bandwidth value can vary depending on the specific dataset and bandwidth parameter depends on the spatial pattern of the data}

\item{split_value}{Splitting value for dividing the dataset into training and testing sets, e.g. 0.7 or 0.8}

\item{gaussian_kernel}{Spatial weight function of the GWR model, e.g. gaussian_kernel}

\item{nfolds}{Specifies the number of folds to use in the cross-validation process for selecting the optimal value of the regularization parameter in LASSO}
}
\value{
A list with the following components:
  - `Important_vars `: Selected important variables based on LASSO model
  - `Optimum_lamda`: Optimum lamda value obtained by CV approach
  - `GWR_y_pred_test`: The GWR predictions at testing locations
  - `R_square`: R-square value
  - `rrmse`: relative root means square error value
  - `mse`: mean squared error
  - `mae`: mean absolute error
}
\description{
GWRLASSO: a hybrid model that uses the LASSO model for important variable selection and GWR model with gaussian kernel for prediction at an unknown location based on the selected variables.
}
\examples{
  n<- 100
  p<- 7
  m<-sqrt(n)
  id<-seq(1:n)
  x<-matrix(runif(n*p), ncol=p)
  e<-rnorm(n, mean=0, sd=1)
  xy_grid<-expand.grid(c(1:m),c(1:m))
  Latitude<-xy_grid[,1]
  Longitude<-xy_grid[,2]
  B0<-(Latitude+Longitude)/6
  B1<-(Latitude/3)
  B2<-(Longitude/3)
  B3<-(2*Longitude)
  B4<-2*(Latitude+Longitude)/6
  B5<-(4*Longitude/3)
  B6<-2*(Latitude+Longitude)/18
  B7<-(4*Longitude/18)
  y<-B0+(B1*x[,1])+(B2*x[,2])+(B3*x[,3])+(B4*x[,4])+(B5*x[,5])+(B6*x[,6])+(B7*x[,7])+e
  data_sp<-data.frame(y,x,Latitude,Longitude)
GWRLASSO_gau<-GWRLASSO_gaussian(data_sp,0.8,0.7,gaussian_kernel,10)
}
\references{
1. Brunsdon, C., Fotheringham, A.S. and Charlton, M,E. (1996).Geographically weighted regression: a method for exploring spatial non-stationarity. Geogr Anal.28(4),281-298.<DOI:10.1111/j.1538-4632.1996.tb00936.x>.
2. Friedman, J., Hastie, T. and Tibshirani, R. (2010). Regularization Paths for Generalized Linear Models via Coordinate Descent. Journal of Statistical Software,33(1),1-22.<DOI:10.18637/jss.v033.i01>.
3. Wheeler, D. C. (2009).Simultaneous coefficient penalization and model selection in geographically weighted regression: the geographically weighted lasso.Environment and planning A, 41(3), 722-742.<DOI:10.1068/a40256>.
}
