% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{class}
\name{geomongo}
\alias{geomongo}
\title{mongodb geospatial methods ( using PyMongo in R )}
\usage{
# init <- geomongo$new(host = 'localhost', port = 27017,

       #                      tz_aware = FALSE, connect = TRUE, ...)
}
\description{
mongodb geospatial methods ( using PyMongo in R )

mongodb geospatial methods ( using PyMongo in R )
}
\details{
See the reference link for more details on the \emph{ellipsis} (...) concerning the additional parameters of the MongoClient()

the \emph{geomongo$new} method initializes the MongoClient

the \emph{getClient} method returns a \emph{"pymongo.mongo_client.MongoClient"} object

the \emph{read_mongo_bson} method allows the user to read a file/string using the \emph{bson.json_util} module, which loads MongoDB Extended JSON data ( SEE \emph{https://stackoverflow.com/questions/42089045/bson-errors-invaliddocument-key-oid-must-not-start-with-trying-to-insert} )

the \emph{geoInsert} method allows the user to import data to a mongo-db from a \emph{folder}, \emph{file} or \emph{list}

the \emph{geoQuery} method allows the user to perform geospatial queries using one of the \emph{find}, \emph{aggregate} or \emph{command} methods

For spherical query operators to function properly, you must convert distances to radians, and convert from radians to the distances units used by your application.

To convert distance to radians: divide the distance by the radius of the sphere (e.g. the Earth) in the same units as the distance measurement.
To convert radians to distance: multiply the radian measure by the radius of the sphere (e.g. the Earth) in the units system that you want to convert the distance to.

The equatorial radius of the Earth is approximately 3,963.2 miles or 6,378.1 kilometers.

If specifying latitude and longitude coordinates, list the longitude first and then latitude:

Valid longitude values are between -180 and 180, both inclusive.
Valid latitude values are between -90 and 90 (both inclusive).
}
\section{Methods}{


\describe{
 \item{\code{geomongo$new(host = 'localhost', port = 27017, tz_aware = FALSE, connect = TRUE, ...)}}{}

 \item{\code{--------------}}{}

 \item{\code{getClient()}}{}

 \item{\code{--------------}}{}

 \item{\code{read_mongo_bson(FILE = NULL, STR = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{geoInsert(DATA = NULL, TYPE_DATA = NULL, COLLECTION = NULL, GEOMETRY_NAME = NULL, read_method = "geojsonR")}}{}

 \item{\code{--------------}}{}

 \item{\code{geoQuery(QUERY = NULL, METHOD = NULL, COLLECTION = NULL, DATABASE = NULL, GEOMETRY_NAME = NULL, TO_LIST = FALSE)}}{}
 }
}

\examples{

\dontrun{

library(GeoMongo)

init = geomongo$new()

getter_client = init$getClient()

init_db = getter_client$get_database("example_db")

init_col = init_db$get_collection("example_collection")

#--------------------------
# geonear using 'aggregate'
#--------------------------

query_geonear = list('$geoNear' = list(near = list(type = "Point", coordinates = c(-122.5, 37.1)),

                     distanceField = "distance", maxDistance = 900 * 1609.34,

                     distanceMultiplier = 1 / 1609.34, spherical = TRUE))


init$geoQuery(QUERY = query_geonear, METHOD = "aggregate", COLLECTION = init_col,

              DATABASE = init_db, GEOMETRY_NAME = "location", TO_LIST = FALSE)
}
}
\references{
https://github.com/mongodb/mongo-python-driver, https://docs.mongodb.com/manual/tutorial/calculate-distances-using-spherical-geometry-with-2d-geospatial-indexes/
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{geomongo$new()}}
\item \href{#method-getClient}{\code{geomongo$getClient()}}
\item \href{#method-read_mongo_bson}{\code{geomongo$read_mongo_bson()}}
\item \href{#method-geoInsert}{\code{geomongo$geoInsert()}}
\item \href{#method-geoQuery}{\code{geomongo$geoQuery()}}
\item \href{#method-clone}{\code{geomongo$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geomongo$new(
  host = "localhost",
  port = 27017,
  tz_aware = FALSE,
  connect = TRUE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{(optional) hostname or IP address or Unix domain socket path of a single mongod or mongos instance to connect to, or a mongodb URI, or a list of hostnames / mongodb URIs. See the reference link for more information.}

\item{\code{port}}{(optional) port number on which to connect}

\item{\code{tz_aware}}{(optional) if TRUE, datetime instances returned as values in a document by this MongoClient will be timezone aware (otherwise they will be naive)}

\item{\code{connect}}{(optional) if TRUE (the default), immediately begin connecting to MongoDB in the background. Otherwise connect on the first operation}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getClient"></a>}}
\if{latex}{\out{\hypertarget{method-getClient}{}}}
\subsection{Method \code{getClient()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geomongo$getClient()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-read_mongo_bson"></a>}}
\if{latex}{\out{\hypertarget{method-read_mongo_bson}{}}}
\subsection{Method \code{read_mongo_bson()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geomongo$read_mongo_bson(FILE = NULL, STR = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{FILE}}{a character string specifying a valid path to a file ( applies to \emph{read_mongo_bson} method )}

\item{\code{STR}}{a character string ( applies to \emph{read_mongo_bson} method )}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoInsert"></a>}}
\if{latex}{\out{\hypertarget{method-geoInsert}{}}}
\subsection{Method \code{geoInsert()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geomongo$geoInsert(
  DATA = NULL,
  TYPE_DATA = NULL,
  COLLECTION = NULL,
  GEOMETRY_NAME = NULL,
  read_method = "geojsonR"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{DATA}}{a valid path to a file/folder or a list ( applies to \emph{geoInsert} method )}

\item{\code{TYPE_DATA}}{a character string. One of 'folder', 'file', 'dict_one' (takes as input a \emph{list} or a \emph{character string}) or 'dict_many' (takes as input a \emph{list} or a \emph{character string vector}) ( applies to \emph{geoInsert} method )}

\item{\code{COLLECTION}}{a \emph{pymongo.collection.Collection} object ( applies to \emph{geoInsert} and \emph{geoQuery} methods )}

\item{\code{GEOMETRY_NAME}}{a character string specifying the name of the geometry object, as it appears in the file/string ( applies to \emph{geoInsert} and \emph{geoQuery} methods )}

\item{\code{read_method}}{a character string specifying the method to use to read the data. Either using the \emph{"geojsonR"} (package) or the \emph{"mongo_bson"} utility function ( applies to \emph{geoInsert} method )}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoQuery"></a>}}
\if{latex}{\out{\hypertarget{method-geoQuery}{}}}
\subsection{Method \code{geoQuery()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geomongo$geoQuery(
  QUERY = NULL,
  METHOD = NULL,
  COLLECTION = NULL,
  DATABASE = NULL,
  GEOMETRY_NAME = NULL,
  TO_LIST = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{QUERY}}{a named list specifying the query to use in mongodb ( applies to \emph{geoQuery} method )}

\item{\code{METHOD}}{a character string specifying the method to use to perform geospatial queries in mongodb. One of "find", "aggregate" OR "command" ( applies to \emph{geoQuery} method )}

\item{\code{COLLECTION}}{a \emph{pymongo.collection.Collection} object ( applies to \emph{geoInsert} and \emph{geoQuery} methods )}

\item{\code{DATABASE}}{a \emph{"pymongo.database.Database"} object ( applies to \emph{geoQuery} method )}

\item{\code{GEOMETRY_NAME}}{a character string specifying the name of the geometry object, as it appears in the file/string ( applies to \emph{geoInsert} and \emph{geoQuery} methods )}

\item{\code{TO_LIST}}{either TRUE or FALSE. If TRUE then the output of the \emph{geoQuery} method will be a list, otherwise a data.table (matrix) object ( applies to \emph{geoQuery} method )}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geomongo$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
