% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getModelData4Forestplot.R
\name{getModelData4Forestplot}
\alias{getModelData4Forestplot}
\title{Get model data}
\usage{
getModelData4Forestplot(
  regr.obj,
  exp = TRUE,
  variablesOfInterest.regexp = NULL,
  add_first_as_ref = FALSE
)
}
\arguments{
\item{regr.obj}{A list with all the fits that have variables that are to
be identified through the regular expression}

\item{exp}{Report in exponential form. Default true since the function was built for
use with survival models.}

\item{variablesOfInterest.regexp}{A regular expression identifying the variables
that are of interest of comparing. For instance it can be "(score|index|measure)"
that finds scores in different models that should be compared.}

\item{add_first_as_ref}{If you want that the first variable should be reference for
that group of variables. The ref is a variable with the estimate 1 or 0 depending
if exp() and the confidence interval 0.}
}
\description{
A helper function for \code{\link{forestplotCombineRegrObj}()}. Extracts
the data from the regression model fits and returns a \code{list}
with model data gathered by the function [broom::tidy()]
}
\examples{
org.par <- par("ask" = TRUE)

# simulated data to test
library(tidyverse)
set.seed(10)
cov <- tibble(ftime = rexp(200),
              fstatus = sample(0:1, 200, replace = TRUE),
              x1 = runif(200),
              x2 = runif(200),
              x3 = runif(200)) |> 
  # Add some column labels
  Gmisc::set_column_labels(x1 = "First variable",
                           x2 = "Second variable")

library(rms)
ddist <- datadist(cov)
options(datadist = "ddist")

fit1 <- cph(Surv(ftime, fstatus) ~ x1 + x2, data = cov)
fit2 <- cph(Surv(ftime, fstatus) ~ x1 + x3, data = cov)

list(`First model` = fit1, 
     `Second model` = fit2) |> 
  forestplotCombineRegrObj(variablesOfInterest.regexp = "(x2|x3)") |> 
  fp_set_style(lines = "steelblue",
               box = "darkblue")

# How to add expressions to the plot label
list(fit1, fit2) |> 
  forestplotCombineRegrObj(variablesOfInterest.regexp = "(x2|x3)",
                           reference.names = c("First model", "Second model"),
                           post_process_data = \(data) {
                             data$column_label[4] <- c(rlang::expr(expression(Fever >= 38.5)))
                             return(data)
                           })

par(org.par)
}
\keyword{internal}
